package org.qubership.atp.tdm.controllers.api.dto.actions;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.tdm.controllers.api.dto.actions.ApiDataFilterDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * OccupyFullRowRequestDto
 */

@JsonTypeName("OccupyFullRowRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T06:59:11.360601794Z[Etc/UTC]")
public class OccupyFullRowRequestDto {

  @JsonProperty("response-column-names")
  @Valid
  private List<String> responseColumnNames = null;

  @JsonProperty("search-row-parameters-set")
  @Valid
  private List<ApiDataFilterDto> searchRowParametersSet = null;

  public OccupyFullRowRequestDto responseColumnNames(List<String> responseColumnNames) {
    this.responseColumnNames = responseColumnNames;
    return this;
  }

  public OccupyFullRowRequestDto addResponseColumnNamesItem(String responseColumnNamesItem) {
    if (this.responseColumnNames == null) {
      this.responseColumnNames = new ArrayList<>();
    }
    this.responseColumnNames.add(responseColumnNamesItem);
    return this;
  }

  /**
   * Get responseColumnNames
   * @return responseColumnNames
  */
  
  @Schema(name = "response-column-names", required = false)
  public List<String> getResponseColumnNames() {
    return responseColumnNames;
  }

  public void setResponseColumnNames(List<String> responseColumnNames) {
    this.responseColumnNames = responseColumnNames;
  }

  public OccupyFullRowRequestDto searchRowParametersSet(List<ApiDataFilterDto> searchRowParametersSet) {
    this.searchRowParametersSet = searchRowParametersSet;
    return this;
  }

  public OccupyFullRowRequestDto addSearchRowParametersSetItem(ApiDataFilterDto searchRowParametersSetItem) {
    if (this.searchRowParametersSet == null) {
      this.searchRowParametersSet = new ArrayList<>();
    }
    this.searchRowParametersSet.add(searchRowParametersSetItem);
    return this;
  }

  /**
   * Get searchRowParametersSet
   * @return searchRowParametersSet
  */
  @Valid 
  @Schema(name = "search-row-parameters-set", required = false)
  public List<ApiDataFilterDto> getSearchRowParametersSet() {
    return searchRowParametersSet;
  }

  public void setSearchRowParametersSet(List<ApiDataFilterDto> searchRowParametersSet) {
    this.searchRowParametersSet = searchRowParametersSet;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OccupyFullRowRequestDto occupyFullRowRequest = (OccupyFullRowRequestDto) o;
    return Objects.equals(this.responseColumnNames, occupyFullRowRequest.responseColumnNames) &&
        Objects.equals(this.searchRowParametersSet, occupyFullRowRequest.searchRowParametersSet);
  }

  @Override
  public int hashCode() {
    return Objects.hash(responseColumnNames, searchRowParametersSet);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OccupyFullRowRequestDto {\n");
    sb.append("    responseColumnNames: ").append(toIndentedString(responseColumnNames)).append("\n");
    sb.append("    searchRowParametersSet: ").append(toIndentedString(searchRowParametersSet)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

