package org.qubership.atp.tdm.controllers.api.dto.statistics;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ConsumedStatisticsItemDto
 */

@JsonTypeName("ConsumedStatisticsItem")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T06:59:11.699458717Z[Etc/UTC]")
public class ConsumedStatisticsItemDto {

  @JsonProperty("consumed")
  @Valid
  private List<Long> consumed = null;

  @JsonProperty("context")
  private String context;

  @JsonProperty("details")
  @Valid
  private List<ConsumedStatisticsItemDto> details = null;

  @JsonProperty("environment")
  private String environment;

  @JsonProperty("system")
  private String system;

  public ConsumedStatisticsItemDto consumed(List<Long> consumed) {
    this.consumed = consumed;
    return this;
  }

  public ConsumedStatisticsItemDto addConsumedItem(Long consumedItem) {
    if (this.consumed == null) {
      this.consumed = new ArrayList<>();
    }
    this.consumed.add(consumedItem);
    return this;
  }

  /**
   * Get consumed
   * @return consumed
  */
  
  @Schema(name = "consumed", required = false)
  public List<Long> getConsumed() {
    return consumed;
  }

  public void setConsumed(List<Long> consumed) {
    this.consumed = consumed;
  }

  public ConsumedStatisticsItemDto context(String context) {
    this.context = context;
    return this;
  }

  /**
   * Get context
   * @return context
  */
  
  @Schema(name = "context", required = false)
  public String getContext() {
    return context;
  }

  public void setContext(String context) {
    this.context = context;
  }

  public ConsumedStatisticsItemDto details(List<ConsumedStatisticsItemDto> details) {
    this.details = details;
    return this;
  }

  public ConsumedStatisticsItemDto addDetailsItem(ConsumedStatisticsItemDto detailsItem) {
    if (this.details == null) {
      this.details = new ArrayList<>();
    }
    this.details.add(detailsItem);
    return this;
  }

  /**
   * Get details
   * @return details
  */
  @Valid 
  @Schema(name = "details", required = false)
  public List<ConsumedStatisticsItemDto> getDetails() {
    return details;
  }

  public void setDetails(List<ConsumedStatisticsItemDto> details) {
    this.details = details;
  }

  public ConsumedStatisticsItemDto environment(String environment) {
    this.environment = environment;
    return this;
  }

  /**
   * Get environment
   * @return environment
  */
  
  @Schema(name = "environment", required = false)
  public String getEnvironment() {
    return environment;
  }

  public void setEnvironment(String environment) {
    this.environment = environment;
  }

  public ConsumedStatisticsItemDto system(String system) {
    this.system = system;
    return this;
  }

  /**
   * Get system
   * @return system
  */
  
  @Schema(name = "system", required = false)
  public String getSystem() {
    return system;
  }

  public void setSystem(String system) {
    this.system = system;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConsumedStatisticsItemDto consumedStatisticsItem = (ConsumedStatisticsItemDto) o;
    return Objects.equals(this.consumed, consumedStatisticsItem.consumed) &&
        Objects.equals(this.context, consumedStatisticsItem.context) &&
        Objects.equals(this.details, consumedStatisticsItem.details) &&
        Objects.equals(this.environment, consumedStatisticsItem.environment) &&
        Objects.equals(this.system, consumedStatisticsItem.system);
  }

  @Override
  public int hashCode() {
    return Objects.hash(consumed, context, details, environment, system);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConsumedStatisticsItemDto {\n");
    sb.append("    consumed: ").append(toIndentedString(consumed)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("    environment: ").append(toIndentedString(environment)).append("\n");
    sb.append("    system: ").append(toIndentedString(system)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

