/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.tdm.model.statistics;

import java.util.Arrays;
import java.util.List;

import javax.annotation.Nonnull;

public enum UsersOccupyFields {
    TABLE_TITLE("table_title","type"),
    OCCUPIED_BY("occupied_by", "user"),
    SYSTEM("system"),
    ENVIRONMENT("environment");

    private final List<String> values;

    UsersOccupyFields(String ...values) {
        this.values = Arrays.asList(values);
    }

    public List<String> getValues() {
        return values;
    }

    /**
     * Get search condition type.
     */
    public static UsersOccupyFields find(@Nonnull String value) {
        for (UsersOccupyFields type : values()) {
            if (type.getValues().stream().anyMatch(value::equalsIgnoreCase)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Unknown search condition type: " + value);
    }
}