/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.ei;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ExportScope;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.ei.TdmExportExecutor;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.ei.ExportImportObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExportImportTest
extends AbstractTestDataTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractExportImportTest.class);
    protected StringBuilder exportJson = new StringBuilder();
    protected String query = "select sim from tdm_test_data_refresh_unoccupied_table";
    protected String tableName = "tdm_test_data_export_import";
    protected String tableTitle = "TDM Test Data Run Export Import";
    protected String tablePrefix = "tdm_";
    protected Gson json = new Gson();
    protected ExportImportObject exportImportObject;
    protected static final UUID exportImportProjectId = UUID.randomUUID();

    protected Set<String> createSetUuid() {
        return Stream.of(this.tablePrefix + UUID.randomUUID(), this.tablePrefix + UUID.randomUUID()).collect(Collectors.toSet());
    }

    public void runExport(TdmExportExecutor exportExecutor, ExportScope exportScope, String tableName) throws Exception {
        TestDataTableCatalog table = this.createTestDataTableCatalog(exportImportProjectId, systemId, environmentId, this.tableTitle, tableName, this.query);
        this.createTestDataTable(tableName);
        this.createTestDataTableColumns(tableName);
        this.createDateCleanupConfig(table);
        this.createFlagsTable(tableName);
        exportExecutor.exportToFolder(new ExportImportData(exportImportProjectId, exportScope, ExportFormat.ATP), Paths.get("", new String[0]));
        File file = new File("ExportImportObject/" + exportImportProjectId + ".json");
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.exportJson.append(line);
            }
            this.exportImportObject = (ExportImportObject)this.json.fromJson(this.exportJson.toString(), ExportImportObject.class);
        }
        catch (IOException e) {
            log.error("File hasn't been found. ", (Throwable)e);
        }
    }
}

