/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.cleanup.CleanupResults;
import org.qubership.atp.tdm.model.cleanup.CleanupSettings;
import org.qubership.atp.tdm.model.cleanup.CleanupType;
import org.qubership.atp.tdm.model.cleanup.TestDataCleanupConfig;
import org.qubership.atp.tdm.model.cleanup.cleaner.impl.SqlTestDataCleaner;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumnIdentity;
import org.qubership.atp.tdm.repo.CleanupConfigRepository;
import org.qubership.atp.tdm.service.impl.MetricService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;

public class CleanupServiceTest
extends AbstractTestDataTest {
    @MockBean
    private MetricService metricServiceMock;
    @Autowired
    protected CleanupConfigRepository cleanupRepository;

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.environmentsService.getConnectionsSystemById((UUID)ArgumentMatchers.any())).thenReturn((Object)connections);
    }

    @Test
    public void cleanupConfig_saveAndGetCleanup_returnNormalCleanup() throws Exception {
        String tableName = "tdm_save_and_get_cleanup_config";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Save And Get Cleanup Config", tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        TestDataCleanupConfig expectedConfig = this.createSqlCleanupConfig(table, false);
        TestDataCleanupConfig actualConfig = this.cleanupService.getCleanupConfig(expectedConfig.getId());
        Assertions.assertEquals((Object)expectedConfig, (Object)actualConfig);
        this.catalogRepository.deleteByTableName(tableName);
        this.cleanupRepository.deleteAll();
    }

    @Test
    public void cleanupConfig_updateAndGetCleanup_returnNormalCleanup() throws Exception {
        String tableName = "tdm_update_and_get_cleanup_config";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Update And Get Cleanup Config", tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        TestDataCleanupConfig saveConfig = this.createSqlCleanupConfig(table, false);
        TestDataCleanupConfig actualConfig = this.cleanupService.getCleanupConfig(saveConfig.getId());
        TestDataCleanupConfig updateConfig = this.createSqlCleanupConfig(table, false);
        TestDataCleanupConfig expectedConfig = this.cleanupService.getCleanupConfig(updateConfig.getId());
        Assertions.assertNotEquals((Object)actualConfig.getId(), (Object)expectedConfig.getId());
        this.catalogRepository.deleteByTableName(tableName);
        this.cleanupRepository.deleteAll();
    }

    @Test
    public void cleanupConfig_saveAndGetSomeCleanup_returnNormalCleanup() throws Exception {
        String tableTitle = "TDM Save And Get Some Cleanup";
        String tableNameAtpUat = "tdm_save_and_get_some_cleanup_atp_uat";
        String tableNameAtpDev = "tdm_save_and_get_some_cleanup_atp_dev";
        String tableNameAtpQa = "tdm_save_and_get_some_cleanup_atp_qa";
        UUID atpUat = UUID.randomUUID();
        UUID atpDev = UUID.randomUUID();
        UUID atpQa = UUID.randomUUID();
        TestDataTableCatalog tableCatalogUat = this.createTestDataTableCatalog(projectId, systemId, atpUat, tableTitle, tableNameAtpUat);
        this.createTestDataTableCatalog(projectId, systemId, atpDev, tableTitle, tableNameAtpDev);
        this.createTestDataTableCatalog(projectId, systemId, atpQa, tableTitle, tableNameAtpQa);
        ArrayList<UUID> envList = new ArrayList<UUID>();
        envList.add(atpUat);
        envList.add(atpDev);
        envList.add(atpQa);
        this.mockEnvironmentService(envList, systemId, systemId);
        TestDataCleanupConfig expectedConfig = this.createSqlCleanupConfig(tableCatalogUat, true);
        TestDataTableCatalog catalog = this.catalogRepository.findAllByCleanupConfigId(expectedConfig.getId()).stream().filter(c -> c.getTableName().equals(tableNameAtpQa)).findFirst().orElse(new TestDataTableCatalog());
        this.catalogRepository.deleteByTableName(tableNameAtpUat);
        this.catalogRepository.deleteByTableName(tableNameAtpDev);
        this.catalogRepository.deleteByTableName(tableNameAtpQa);
        this.cleanupRepository.deleteAll();
        Assertions.assertEquals((Object)catalog.getCleanupConfigId(), (Object)expectedConfig.getId());
    }

    @Test
    public void cleanupConfig_updateAndGetSomeCleanup_returnNormalCleanup() throws Exception {
        String tableTitle = "TDM Update And Get Some Cleanup";
        String tableNameAtpUat = "tdm_update_and_get_some_cleanup_atp_uat";
        String tableNameAtpDev = "tdm_update_and_get_some_cleanup_atp_dev";
        String tableNameAtpQa = "tdm_update_and_get_some_cleanup_atp_qa";
        UUID atpUat = UUID.randomUUID();
        UUID atpDev = UUID.randomUUID();
        UUID atpQa = UUID.randomUUID();
        TestDataTableCatalog tableCatalogUat = this.createTestDataTableCatalog(projectId, systemId, atpUat, tableTitle, tableNameAtpUat);
        this.createTestDataTableCatalog(projectId, systemId, atpDev, tableTitle, tableNameAtpDev);
        this.createTestDataTableCatalog(projectId, systemId, atpQa, tableTitle, tableNameAtpQa);
        ArrayList<UUID> saveEnvList = new ArrayList<UUID>();
        saveEnvList.add(atpUat);
        saveEnvList.add(atpDev);
        saveEnvList.add(atpQa);
        this.mockEnvironmentService(saveEnvList, systemId, systemId);
        TestDataCleanupConfig savedCleanupConfig = this.createSqlCleanupConfig(tableCatalogUat, true);
        ArrayList<UUID> envForUpdate = new ArrayList<UUID>();
        envForUpdate.add(atpQa);
        envForUpdate.add(atpDev);
        TestDataCleanupConfig updatedCleanupConfig = this.createSqlCleanupConfig(tableNameAtpQa, saveEnvList);
        TestDataCleanupConfig updatedCleanupConfigChanged = this.createSqlCleanupConfig(tableNameAtpQa, envForUpdate);
        this.catalogRepository.deleteByTableName(tableNameAtpUat);
        this.catalogRepository.deleteByTableName(tableNameAtpDev);
        this.catalogRepository.deleteByTableName(tableNameAtpQa);
        this.cleanupRepository.deleteAll();
        Assertions.assertNotEquals((Object)savedCleanupConfig.getId(), (Object)updatedCleanupConfig.getId());
        Assertions.assertNotEquals((Object)savedCleanupConfig.getId(), (Object)updatedCleanupConfigChanged.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void saveCleanupConfig_saveCleanupConfigWithIncorrectCronExpression_getError() throws Exception {
        String tableName = "tdm_cleanup_incorrect_cron_expression";
        String incorrectCronExpression = "ADS";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "incorrectCronExpression", tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        TestDataCleanupConfig cleanupConfig = this.createSqlCleanupConfig(table, false);
        cleanupConfig.setSchedule(incorrectCronExpression);
        CleanupSettings cleanupSettings = new CleanupSettings();
        cleanupSettings.setTestDataCleanupConfig(cleanupConfig);
        cleanupSettings.setTableName(tableName);
        cleanupSettings.setEnvironmentsList(Collections.singletonList(environmentId));
        try {
            this.cleanupService.saveCleanupConfig(cleanupSettings);
        }
        catch (Exception e) {
            String errorMessage = String.format("Check Cron Expression: %s. First and second value cannot be '*'", incorrectCronExpression);
            Assertions.assertEquals((Object)errorMessage, (Object)e.getMessage());
        }
        finally {
            this.cleanupRepository.deleteAll();
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void saveCleanupConfig_saveCleanupConfigWithNullCronExpression_successfullySaved() throws Exception {
        String tableName = "tdm_cleanup_null_cron_expression";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "nullCronExpression", tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        TestDataCleanupConfig cleanupConfig = this.createSqlCleanupConfig(table, false);
        cleanupConfig.setSchedule(null);
        CleanupSettings cleanupSettings = new CleanupSettings();
        cleanupSettings.setTestDataCleanupConfig(cleanupConfig);
        cleanupSettings.setTableName(table.getTableName());
        cleanupSettings.setEnvironmentsList(Collections.singletonList(environmentId));
        try {
            this.cleanupService.saveCleanupConfig(cleanupSettings);
        }
        catch (Exception e) {
            String errorMessage = String.format("Check Cron Expression: %s. First and second value cannot be '*'", null);
            Assertions.assertEquals((Object)errorMessage, (Object)e.getMessage());
        }
        finally {
            this.cleanupRepository.deleteAll();
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    @Test
    public void cleanupConfig_saveAndGetDateCleanup_returnNormalCleanup() throws Exception {
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        String tableName = "tdm_save_and_get_date_cleanup_config";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Save And Get Date Cleanup Config", tableName);
        TestDataCleanupConfig expectedConfig = this.createDateCleanupConfig(table);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        TestDataCleanupConfig actualConfig = this.cleanupService.getCleanupConfig(expectedConfig.getId());
        Assertions.assertEquals((Object)expectedConfig, (Object)actualConfig);
        this.catalogRepository.deleteByTableName(tableName);
        this.cleanupRepository.deleteAll();
    }

    @Test
    public void cleanupConfig_saveSharedCleanup_returnCleanup() throws Exception {
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        String tableName = "tdm_save_shared_cleanup_config";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Save And Get Shared Cleanup Config", tableName);
        TestDataCleanupConfig expectedConfig = this.createSqlCleanupConfig(table, true);
        TestDataCleanupConfig actualConfig = this.cleanupService.getCleanupConfig(expectedConfig.getId());
        Assertions.assertEquals((Object)expectedConfig, (Object)actualConfig);
        this.catalogRepository.deleteByTableName(tableName);
        this.cleanupRepository.deleteAll();
    }

    @Test
    public void cleanupConfig_runCleanup_returnCleanupResults() throws Exception {
        String tableName = "tdm_run_cleanup_config";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Run Cleanup Config", tableName);
        this.createTestDataTable(tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        TestDataCleanupConfig cleanupConfig = this.createSqlCleanupConfig(table, false);
        ArrayList<CleanupResults> expectedCleanupResults = new ArrayList<CleanupResults>();
        expectedCleanupResults.add(new CleanupResults(tableName, 6, 6));
        List actualCleanupResults = this.cleanupService.runCleanup(cleanupConfig.getId());
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertEquals(expectedCleanupResults, (Object)actualCleanupResults);
        this.cleanupService.removeUnused();
        this.cleanupRepository.deleteAll();
        this.catalogRepository.deleteByTableName(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cleanupConfig_runCleanup_returnRuntimeException() throws Exception {
        String tableName = "tdm_run_cleanup_config_runtime_exception";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Run Cleanup Config Runtime Exception", tableName);
        this.createTestDataTable(tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        TestDataCleanupConfig cleanupConfig = this.createErrorSqlCleanupConfig(table, false);
        try {
            this.cleanupService.runCleanup(tableName, cleanupConfig);
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Error while run cleanup. Column 'PartnerR' doesn't exist", (Object)e.getMessage());
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
            this.cleanupService.removeUnused();
            this.cleanupRepository.deleteAll();
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    @Test
    public void cleanupConfig_runDateCleanup_returnCleanupResultsRemovedZero() throws Exception {
        String tableName = "tdm_run_date_cleanup_config";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Run Date Cleanup Config", tableName);
        this.createTestDataTable(tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        TestDataCleanupConfig cleanupConfig = this.createDateCleanupConfig(table);
        ArrayList<CleanupResults> expectedCleanupResults = new ArrayList<CleanupResults>();
        expectedCleanupResults.add(new CleanupResults("tdm_run_date_cleanup_config", 6, 0));
        List actualCleanupResults = this.cleanupService.runCleanup(cleanupConfig.getId());
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertEquals(expectedCleanupResults, (Object)actualCleanupResults);
        this.cleanupService.removeUnused();
        this.cleanupRepository.deleteAll();
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void cleanupConfig_runDateCleanup_returnCleanupResultsRemovedSix() throws Exception {
        String tableName = "tdm_run_date_cleanup_config";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Run Date Cleanup Config", tableName);
        this.createTestDataTable(tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        TestDataCleanupConfig cleanupConfig = this.createDateCleanupConfigToDay(table);
        ArrayList<CleanupResults> expectedCleanupResults = new ArrayList<CleanupResults>();
        expectedCleanupResults.add(new CleanupResults("tdm_run_date_cleanup_config", 6, 6));
        List actualCleanupResults = this.cleanupService.runCleanup(cleanupConfig.getId());
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertEquals(expectedCleanupResults, (Object)actualCleanupResults);
        this.cleanupService.removeUnused();
        this.cleanupRepository.deleteAll();
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void cleanupConfig_getNextScheduledCleanupTime_returnScheduledCleanupTime() throws Exception {
        String nextScheduledRun = this.cleanupService.getNextScheduledRun("0 25 9 ? * * 2016/83");
        Assertions.assertTrue((boolean)nextScheduledRun.contains("09:25:00"));
    }

    @Test
    public void cleanupConfig_removeUnusedCleanupConfig_successfulRemove() throws Exception {
        String tableName = "tdm_remove_unused_cleanup_config";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Remove unused cleanup config", tableName);
        String toBeDeleted = "tdm_remove_unused_cleanup_config_to_be_deleted";
        TestDataTableCatalog tableToBeDeleted = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Remove unused cleanup config 2", toBeDeleted);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        TestDataCleanupConfig expectedConfig = this.createSqlCleanupConfig(table, false);
        this.createSqlCleanupConfig(tableToBeDeleted, false);
        Assertions.assertEquals((long)2L, (long)this.cleanupRepository.count());
        this.catalogRepository.deleteByTableName(toBeDeleted);
        this.cleanupService.removeUnused();
        Assertions.assertEquals((long)1L, (long)this.cleanupRepository.count());
        Assertions.assertEquals((Object)expectedConfig, (Object)this.cleanupService.getCleanupConfig(expectedConfig.getId()));
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void cleanupSettings_getCleanupSettings_returnCleanupSettingsAndEnvId() throws Exception {
        String tableName = "tdm_get_cleanup_settings";
        String tableTitle = "TDM get cleanup settings";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        TestDataCleanupConfig cleanupConfig = this.createSqlCleanupConfig(table, false);
        CleanupSettings cleanupSettings = this.cleanupService.getCleanupSettings(cleanupConfig.getId());
        Assertions.assertEquals((Object)cleanupConfig, (Object)cleanupSettings.getTestDataCleanupConfig());
        Assertions.assertEquals((Object)environmentId, cleanupSettings.getEnvironmentsList().get(0));
        this.cleanupRepository.deleteAll();
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void getTablesForCleanupWithEnvList_callFunction_returnTablesList() {
        ArrayList<String> expectedList = new ArrayList<String>();
        expectedList.add("table_name1");
        expectedList.add("table_name2");
        UUID systemId1 = UUID.randomUUID();
        UUID systemId2 = UUID.randomUUID();
        UUID envId1 = UUID.randomUUID();
        UUID envId2 = UUID.randomUUID();
        this.createTestDataTableCatalog(projectId, systemId1, envId1, "table_title", (String)expectedList.get(0));
        this.createTestDataTableCatalog(projectId, systemId2, envId2, "table_title", (String)expectedList.get(1));
        ArrayList<UUID> envsList = new ArrayList<UUID>();
        envsList.add(envId1);
        envsList.add(envId2);
        this.mockEnvironmentService(envsList, systemId1, systemId2);
        List resultTables = this.cleanupService.getTablesByTableNameAndEnvironmentsListWithSameSystemName(envsList, (String)expectedList.get(0));
        Collections.sort(resultTables);
        Assertions.assertEquals(expectedList, (Object)resultTables);
        this.cleanupRepository.deleteAll();
        this.catalogRepository.deleteByTableName("table_name1");
        this.catalogRepository.deleteByTableName("table_name2");
    }

    @Test
    public void cleanupConfig_runCleanupByCleanupSettings_returnCleanupResults() throws Exception {
        String tableName = "tdm_run_cleanup_config_by_settings";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Run Cleanup Config", tableName);
        this.createTestDataTable(tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, UUID.randomUUID());
        TestDataCleanupConfig cleanupConfig = this.createSqlCleanupConfig(table, false);
        CleanupSettings cleanupSettings = new CleanupSettings();
        cleanupSettings.setTestDataCleanupConfig(cleanupConfig);
        cleanupSettings.setTableName(tableName);
        cleanupSettings.setEnvironmentsList(Collections.singletonList(environmentId));
        ArrayList<CleanupResults> expectedCleanupResults = new ArrayList<CleanupResults>();
        expectedCleanupResults.add(new CleanupResults(tableName, 6, 6));
        List actualCleanupResults = this.cleanupService.runCleanup(cleanupSettings);
        this.cleanupService.removeUnused();
        this.cleanupRepository.deleteAll();
        this.catalogRepository.deleteByTableName(tableName);
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertEquals(expectedCleanupResults, (Object)actualCleanupResults);
    }

    @Test
    public void cleanupConfig_saveConfigWithOutTableName_returnError() {
        String crone = "0 0 9 ? * *";
        String tableName = "";
        try {
            this.cleanupService.saveCleanupConfig(this.createCleanupSettings(crone, tableName));
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Table Name is null", (Object)e.getMessage());
        }
    }

    @Test
    public void checkSqlCleanupQueryParsing_validQuery() {
        String sqlQuery = "select * from nc_objects where object_id = ${'CUSTOMER_ID'} and (select 24 * (sysdate - (INTERVAL '1' HOUR) - to_date(${'CREATED_WHEN'}, 'YYYY-MM-DD hh24:mi:ss')) from dual) < 24";
        int queryTimeout = 10000;
        ArrayList<String> expectedQueryColumns = new ArrayList<String>();
        expectedQueryColumns.add("CUSTOMER_ID");
        expectedQueryColumns.add("CREATED_WHEN");
        TestDataTable testDataTable = this.initTestDataTable();
        SqlTestDataCleaner cleaner = new SqlTestDataCleaner(null, sqlQuery, queryTimeout);
        List actualQueryColumns = cleaner.collectParameterColumnsList(testDataTable);
        Assertions.assertArrayEquals((Object[])expectedQueryColumns.toArray(), (Object[])actualQueryColumns.toArray(), (String)("Query parameters placeholders don't match: " + expectedQueryColumns + " vs. " + actualQueryColumns));
        boolean isValid = cleaner.parseQuery();
        Assertions.assertTrue((boolean)isValid, (String)("Query (after replacements) is assumed to be valid, but:\n" + cleaner.getQuery()));
    }

    @Test
    public void checkSqlCleanupQueryParsing_validQuery_repeatedPlaceHolders() {
        String sqlQuery = "select * from nc_objects where object_id = ${'CUSTOMER_ID'}  and  (select 24 * (sysdate - (INTERVAL '1' HOUR) - to_date(${'CREATED_WHEN'}, 'YYYY-MM-DD hh24:mi:ss')) from dual) < 24 and  parent_id != ${'CUSTOMER_ID'}";
        int queryTimeout = 10000;
        ArrayList<String> expectedQueryColumns = new ArrayList<String>();
        expectedQueryColumns.add("CUSTOMER_ID");
        expectedQueryColumns.add("CREATED_WHEN");
        expectedQueryColumns.add("CUSTOMER_ID");
        TestDataTable testDataTable = this.initTestDataTable();
        SqlTestDataCleaner cleaner = new SqlTestDataCleaner(null, sqlQuery, queryTimeout);
        List actualQueryColumns = cleaner.collectParameterColumnsList(testDataTable);
        Assertions.assertArrayEquals((Object[])expectedQueryColumns.toArray(), (Object[])actualQueryColumns.toArray(), (String)("Query parameters placeholders don't match: " + expectedQueryColumns + " vs. " + actualQueryColumns));
        boolean isValid = cleaner.parseQuery();
        Assertions.assertTrue((boolean)isValid, (String)("Query (after replacements) is assumed to be valid, but:\n" + cleaner.getQuery()));
    }

    private CleanupSettings createCleanupSettings(String cron, String tableName) {
        TestDataCleanupConfig cleanupConfig = new TestDataCleanupConfig();
        cleanupConfig.setEnabled(true);
        cleanupConfig.setSchedule(cron);
        cleanupConfig.setShared(false);
        cleanupConfig.setQueryTimeout(Integer.valueOf(30));
        cleanupConfig.setType(CleanupType.SQL);
        cleanupConfig.setSearchSql("select * from test_data_table_catalog where table_title = ${'Partner'}");
        cleanupConfig.setShared(false);
        CleanupSettings cleanupSettings = new CleanupSettings();
        cleanupSettings.setTestDataCleanupConfig(cleanupConfig);
        cleanupSettings.setTableName(tableName);
        cleanupSettings.setEnvironmentsList(Collections.singletonList(UUID.randomUUID()));
        return cleanupSettings;
    }

    private TestDataTableColumn createColumn(String tableName, String columnName) {
        TestDataTableColumnIdentity columnIdentity = new TestDataTableColumnIdentity();
        columnIdentity.setTableName(tableName);
        columnIdentity.setColumnName(columnName);
        return new TestDataTableColumn(columnIdentity);
    }

    private TestDataTable initTestDataTable() {
        TestDataTable testDataTable = new TestDataTable();
        testDataTable.setName("tdm_test1");
        testDataTable.setTitle("TDM Test 1");
        ArrayList<TestDataTableColumn> tableColumns = new ArrayList<TestDataTableColumn>();
        tableColumns.add(this.createColumn("tdm_test1", "CUSTOMER_ID"));
        tableColumns.add(this.createColumn("tdm_test1", "CUSTOMER_TYPE"));
        tableColumns.add(this.createColumn("tdm_test1", "CREATED_WHEN"));
        testDataTable.setColumns(tableColumns);
        return testDataTable;
    }
}

