/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.env.configurator.model.Project;
import org.qubership.atp.tdm.model.ColumnType;
import org.qubership.atp.tdm.model.LinkSetupResult;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumnIdentity;
import org.qubership.atp.tdm.service.ColumnService;
import org.springframework.beans.factory.annotation.Autowired;

public class ColumnServiceTest
extends AbstractTestDataTest {
    @Autowired
    protected ColumnService columnService;
    private static final UUID projectId = UUID.randomUUID();
    private static final Project project = new Project(){
        {
            this.setName("Test Cleanup Project");
            this.setId(projectId);
            this.setEnvironments(Collections.singletonList(environment));
        }
    };

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.environmentsService.getLazySystems((UUID)ArgumentMatchers.any())).thenReturn(Collections.singletonList(lazySystem));
        Mockito.when((Object)this.environmentsService.getConnectionsSystemById((UUID)ArgumentMatchers.any())).thenReturn((Object)connections);
    }

    @Test
    public void columnService_getColumnLink_returnLink() {
        String expectedLink = "http://localhost:8080//?objectId=";
        String actualLink = this.columnService.getColumnLink(projectId, systemId, "?objectId=");
        Assertions.assertEquals((Object)expectedLink, (Object)actualLink);
    }

    @Test
    public void columnService_setupColumnLinks_linksSet() {
        String tableName = "tdm_test_setup_column_link";
        String tableTitle = "Tdm Test Setup Column Link";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        ArrayList<TestDataTableColumn> expectedTestDataTableColumns = new ArrayList<TestDataTableColumn>();
        TestDataTableColumn testDataTableColumn = new TestDataTableColumn(new TestDataTableColumnIdentity(tableName, "sim"), ColumnType.LINK, null, "http://localhost:8080//?objectId=", false);
        expectedTestDataTableColumns.add(testDataTableColumn);
        this.columnService.setupColumnLinks(Boolean.valueOf(false), projectId, systemId, tableName, "sim", "?objectId=", Boolean.valueOf(false));
        List actualTestDataTableColumns = this.columnRepository.findAllByIdentityTableName(tableName);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals(expectedTestDataTableColumns, (Object)actualTestDataTableColumns);
    }

    @Test
    public void columnService_setupBulkColumnLinks_linksSet() {
        String tableName = "tdm_test_setup_column_link_bulk";
        String tableTitle = "Tdm Test Setup Column Link Bulk";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        ArrayList<TestDataTableColumn> expectedTestDataTableColumns = new ArrayList<TestDataTableColumn>();
        TestDataTableColumn testDataTableColumn = new TestDataTableColumn(new TestDataTableColumnIdentity(tableName, "sim"), ColumnType.LINK, null, "http://localhost:8080//?objectId=", true);
        expectedTestDataTableColumns.add(testDataTableColumn);
        this.columnService.setupColumnLinks(Boolean.valueOf(true), projectId, systemId, tableName, "sim", "?objectId=", Boolean.valueOf(false));
        List actualTestDataTableColumns = this.columnRepository.findAllByIdentityTableName(tableName);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals(expectedTestDataTableColumns, (Object)actualTestDataTableColumns);
    }

    @Test
    public void columnService_setupColumnLinksWithValueFromTableCell_linksSet() {
        String tableName = "tdm_test_setup_column_link_with_value_from_table_cell";
        String tableTitle = "Tdm Test Setup Column Link With Value From Table Cell";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        ArrayList<TestDataTableColumn> expectedTestDataTableColumns = new ArrayList<TestDataTableColumn>();
        TestDataTableColumn testDataTableColumn = new TestDataTableColumn(new TestDataTableColumnIdentity(tableName, "sim"), ColumnType.LINK, null, "", false);
        expectedTestDataTableColumns.add(testDataTableColumn);
        this.columnService.setupColumnLinks(Boolean.valueOf(false), projectId, systemId, tableName, "sim", "", Boolean.valueOf(true));
        List actualTestDataTableColumns = this.columnRepository.findAllByIdentityTableName(tableName);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals(expectedTestDataTableColumns, (Object)actualTestDataTableColumns);
    }

    @Test
    public void columnService_setupColumnLink_linkSetupResult() {
        String tableName = "tdm_test_linkSetupResult";
        String tableTitle = "TDM Test Link Setup Result";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        this.columnService.setupColumnLinks(Boolean.valueOf(true), projectId, systemId, tableName, "sim", "?objectId=", Boolean.valueOf(false));
        LinkSetupResult expected = this.columnService.setUpLinks(projectId, systemId, tableName);
        LinkSetupResult actual = new LinkSetupResult();
        actual.setColumnNames("sim");
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

