/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Expression;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValueObject;
import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class JdbcEscape
extends Expression {
    private Type _type;
    private SqlObject _val;

    public JdbcEscape(Type type, SqlObject val) {
        this._type = type;
        this._val = val;
    }

    @Override
    public boolean hasParens() {
        return false;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        this._val.collectSchemaObjects(vContext);
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        app.append("{").append((Object)this._type).append(this._val).append("}");
    }

    public static JdbcEscape date(Date d) {
        java.sql.Date sqlDate = d instanceof java.sql.Date ? (java.sql.Date)d : new java.sql.Date(d.getTime());
        return new JdbcEscape(Type.DATE, new ValueObject(sqlDate));
    }

    public static JdbcEscape date(LocalDate d) {
        return JdbcEscape.date(java.sql.Date.valueOf(d));
    }

    public static JdbcEscape date(TemporalAccessor t) {
        return JdbcEscape.date(LocalDate.from(t));
    }

    public static JdbcEscape time(Date d) {
        Time sqlTime = d instanceof Time ? (Time)d : new Time(d.getTime());
        return new JdbcEscape(Type.TIME, new ValueObject(sqlTime));
    }

    public static JdbcEscape time(LocalTime t) {
        return JdbcEscape.time(Time.valueOf(t));
    }

    public static JdbcEscape time(TemporalAccessor t) {
        return JdbcEscape.time(LocalTime.from(t));
    }

    public static JdbcEscape timestamp(Date d) {
        Timestamp sqlTimestamp = d instanceof Timestamp ? (Timestamp)d : new Timestamp(d.getTime());
        return new JdbcEscape(Type.TIMESTAMP, new ValueObject(sqlTimestamp));
    }

    public static JdbcEscape timestamp(LocalDateTime d) {
        return JdbcEscape.timestamp(Timestamp.valueOf(d));
    }

    public static JdbcEscape timestamp(TemporalAccessor t) {
        return JdbcEscape.timestamp(LocalDateTime.from(t));
    }

    public static enum Type {
        SCALAR_FUNCTION("fn "),
        DATE("d "),
        TIME("t "),
        TIMESTAMP("ts "),
        OUTER_JOIN("oj "),
        STORED_PROCEDURE("call "),
        STORED_PROCEDURE_WITH_RETURN("?= call "),
        ESCAPE("escape ");

        private final String _prefixStr;

        private Type(String prefixStr) {
            this._prefixStr = prefixStr;
        }

        public String toString() {
            return this._prefixStr;
        }
    }
}

