/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.dbspec.basic;

import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbCheckConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbForeignKeyConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbObject;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbColumn
extends DbObject<DbTable>
implements Column {
    private static final Map<Integer, String> _typeNameMap = new HashMap<Integer, String>();
    private final String _typeName;
    private final List<Object> _qualifiers = new ArrayList<Object>();
    private final List<DbConstraint> _constraints = new ArrayList<DbConstraint>();
    private Object _defaultValue;

    public DbColumn(DbTable parent, String name, String typeName, Integer typeLength) {
        this(parent, name, typeName, new Object[]{typeLength});
    }

    public DbColumn(DbTable parent, String name, String typeName, Object ... typeQualifiers) {
        super(parent, name);
        this._typeName = typeName;
        if (typeQualifiers != null) {
            for (Object qual : typeQualifiers) {
                if (qual == null) continue;
                this._qualifiers.add(qual);
            }
        }
    }

    @Override
    public DbTable getTable() {
        return (DbTable)this.getParent();
    }

    @Override
    public String getColumnNameSQL() {
        return this.getName();
    }

    @Override
    public String getTypeNameSQL() {
        return this._typeName;
    }

    @Override
    public Integer getTypeLength() {
        Object first;
        if (!this._qualifiers.isEmpty() && (first = this._qualifiers.get(0)) instanceof Integer) {
            return (Integer)first;
        }
        return null;
    }

    public List<Object> getTypeQualifiers() {
        return this._qualifiers;
    }

    public List<DbConstraint> getConstraints() {
        return this._constraints;
    }

    public DbColumn setDefaultValue(Object defaultValue) {
        this._defaultValue = defaultValue;
        return this;
    }

    @Override
    public Object getDefaultValue() {
        return this._defaultValue;
    }

    public DbConstraint notNull() {
        return this.notNull(null);
    }

    public DbConstraint notNull(String name) {
        DbConstraint constraint = this.getSpec().createColumnConstraint(this, name, Constraint.Type.NOT_NULL);
        return this.addConstraint(constraint);
    }

    public DbConstraint unique() {
        return this.unique(null);
    }

    public DbConstraint unique(String name) {
        DbConstraint constraint = this.getSpec().createColumnConstraint(this, name, Constraint.Type.UNIQUE);
        return this.addConstraint(constraint);
    }

    public DbConstraint primaryKey() {
        return this.primaryKey(null);
    }

    public DbConstraint primaryKey(String name) {
        DbConstraint constraint = this.getSpec().createColumnConstraint(this, name, Constraint.Type.PRIMARY_KEY);
        return this.addConstraint(constraint);
    }

    public DbForeignKeyConstraint references(String referencedTableName) {
        return this.references(null, referencedTableName);
    }

    public DbForeignKeyConstraint references(String name, String referencedTableName) {
        return this.references(name, referencedTableName, null);
    }

    public DbForeignKeyConstraint references(String name, String referencedTableName, String referencedColName) {
        DbTable referencedTable = ((DbSchema)this.getTable().getParent()).findTable(referencedTableName);
        return this.references(name, referencedTable, referencedTable.findColumn(referencedColName));
    }

    public DbForeignKeyConstraint references(String name, String referencedSchemaName, String referencedTableName, String referencedColName) {
        DbTable referencedTable = this.getSpec().findSchema(referencedSchemaName).findTable(referencedTableName);
        return this.references(name, referencedTable, referencedTable.findColumn(referencedColName));
    }

    public DbForeignKeyConstraint references(String name, DbTable referencedTable, DbColumn referencedColumn) {
        DbForeignKeyConstraint fkConstraint = this.getSpec().createColumnForeignKeyConstraint(this, name, referencedTable, referencedColumn);
        return this.addConstraint(fkConstraint);
    }

    public DbCheckConstraint checkCondition(String name, Condition condition) {
        DbCheckConstraint constraint = this.getSpec().createColumnCheckConstraint(this, name, condition);
        return this.addConstraint(constraint);
    }

    public <T extends DbConstraint> T addConstraint(T constraint) {
        this._constraints.add(this.checkOwnership(constraint));
        return constraint;
    }

    public static String getTypeName(int type) {
        String name = _typeNameMap.get(type);
        if (name == null) {
            throw new IllegalArgumentException("Type " + type + " is not a valid sql type");
        }
        return name;
    }

    static {
        try {
            for (Field typeField : Types.class.getFields()) {
                int mods = typeField.getModifiers();
                if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || typeField.getType() != Integer.TYPE) continue;
                Integer val = (Integer)typeField.get(null);
                _typeNameMap.put(val, typeField.getName());
            }
        }
        catch (Exception e) {
            throw new Error("<clinit> cannot access jdbc type constants", e);
        }
    }
}

