/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.structure;

import java.util.List;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTRel;
import org.docx4j.wml.FooterReference;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.HdrFtrRef;
import org.docx4j.wml.HeaderReference;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.SectPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderFooterPolicy {
    protected static Logger log = LoggerFactory.getLogger(HeaderFooterPolicy.class);
    private HeaderPart firstHeaderActive;
    private HeaderPart firstHeader;
    private FooterPart firstFooterActive;
    private FooterPart firstFooter;
    private HeaderPart evenHeader;
    private FooterPart evenFooter;
    private HeaderPart defaultHeader;
    private FooterPart defaultFooter;
    private static Object dummyHeaderFooterMutex = new Object();
    private static HeaderPart dummyHeader;
    private static FooterPart dummyFooter;

    private HeaderFooterPolicy() {
    }

    public HeaderFooterPolicy(SectPr sectPr, HeaderFooterPolicy previousHF, RelationshipsPart rels, BooleanDefaultTrue evenAndOddHeaders) {
        if (sectPr == null) {
            log.error("Passed null sectPr?!");
            return;
        }
        List<CTRel> hdrFtrRefs = null;
        BooleanDefaultTrue titlePage = null;
        if (sectPr.getType() != null && "continuous".equals(sectPr.getType().getVal())) {
            log.debug("this is a continuous section");
            if (previousHF != null) {
                this.firstHeaderActive = previousHF.firstHeaderActive;
                this.firstHeader = previousHF.firstHeader;
                this.firstFooterActive = previousHF.firstFooterActive;
                this.firstFooter = previousHF.firstFooter;
                this.evenHeader = previousHF.evenHeader;
                this.evenFooter = previousHF.evenFooter;
                this.defaultHeader = previousHF.defaultHeader;
                this.defaultFooter = previousHF.defaultFooter;
                return;
            }
        }
        if (previousHF == null) {
            log.debug("previousHF==null");
            previousHF = new HeaderFooterPolicy();
        }
        hdrFtrRefs = sectPr.getEGHdrFtrReferences();
        titlePage = sectPr.getTitlePg();
        this.firstHeader = previousHF.firstHeader;
        if (titlePage != null && titlePage.isVal()) {
            this.firstHeaderActive = previousHF.firstHeader;
        }
        this.defaultHeader = previousHF.defaultHeader;
        this.evenHeader = previousHF.evenHeader;
        this.setHeaderReferences(hdrFtrRefs, rels, titlePage);
        this.firstFooter = previousHF.firstFooter;
        if (titlePage != null && titlePage.isVal()) {
            this.firstFooterActive = previousHF.firstFooter;
        }
        this.defaultFooter = previousHF.defaultFooter;
        this.evenFooter = previousHF.evenFooter;
        this.setFooterReferences(hdrFtrRefs, rels, titlePage);
        if (titlePage != null && titlePage.isVal()) {
            if (this.firstHeaderActive == null) {
                this.firstHeaderActive = this.getDummyHeader();
            }
            if (this.firstFooterActive == null) {
                this.firstFooterActive = this.getDummyFooter();
            }
        }
        if (evenAndOddHeaders == null) {
            log.debug("evenAndOddHeader setting missing; defaults to false");
            this.evenHeader = null;
            this.evenFooter = null;
        } else {
            log.debug("evenAndOddHeader: " + evenAndOddHeaders.isVal());
            if (evenAndOddHeaders.isVal()) {
                if (this.evenHeader == null) {
                    this.evenHeader = this.getDummyHeader();
                }
                if (this.evenFooter == null) {
                    this.evenFooter = this.getDummyFooter();
                }
                if (this.defaultHeader == null) {
                    this.defaultHeader = this.getDummyHeader();
                }
                if (this.defaultFooter == null) {
                    this.defaultFooter = this.getDummyFooter();
                }
            } else {
                this.evenHeader = null;
                this.evenFooter = null;
            }
        }
    }

    private HeaderPart getDummyHeader() {
        if (dummyHeader == null) {
            this.createDummyHeaderFooter();
        }
        return dummyHeader;
    }

    private FooterPart getDummyFooter() {
        if (dummyFooter == null) {
            this.createDummyHeaderFooter();
        }
        return dummyFooter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDummyHeaderFooter() {
        Object object = dummyHeaderFooterMutex;
        synchronized (object) {
            if (dummyHeader == null) {
                ObjectFactory factory = new ObjectFactory();
                try {
                    dummyHeader = new HeaderPart(new PartName("/word/dummyheader.xml"));
                    dummyFooter = new FooterPart(new PartName("/word/dummyfooter.xml"));
                }
                catch (InvalidFormatException invalidFormatException) {
                    // empty catch block
                }
                dummyHeader.setJaxbElement(factory.createHdr());
                ((Hdr)dummyHeader.getJaxbElement()).getContent().add(factory.createP());
                dummyFooter.setJaxbElement(factory.createFtr());
                ((Ftr)dummyFooter.getJaxbElement()).getContent().add(factory.createP());
            }
        }
    }

    private void setHeaderReferences(List<CTRel> hdrFtrRefs, RelationshipsPart rels, BooleanDefaultTrue titlePage) {
        for (CTRel rel : hdrFtrRefs) {
            String relId = rel.getId();
            log.debug("for h|f relId: " + relId);
            Part part = rels.getPart(relId);
            if (!(rel instanceof HeaderReference)) continue;
            HeaderReference headerReference = (HeaderReference)rel;
            if (headerReference.getType() == HdrFtrRef.FIRST) {
                this.firstHeader = (HeaderPart)part;
                if (titlePage == null || !titlePage.isVal()) continue;
                log.debug("setting first page header");
                this.firstHeaderActive = (HeaderPart)part;
                continue;
            }
            if (headerReference.getType() == HdrFtrRef.EVEN) {
                log.debug("setting even page header");
                this.evenHeader = (HeaderPart)part;
                continue;
            }
            log.debug("setting default page header");
            this.defaultHeader = (HeaderPart)part;
        }
    }

    private void setFooterReferences(List<CTRel> hdrFtrRefs, RelationshipsPart rels, BooleanDefaultTrue titlePage) {
        for (CTRel rel : hdrFtrRefs) {
            String relId = rel.getId();
            log.debug("for h|f relId: " + relId);
            Part part = rels.getPart(relId);
            if (!(rel instanceof FooterReference)) continue;
            FooterReference footerReference = (FooterReference)rel;
            if (footerReference.getType() == HdrFtrRef.FIRST) {
                this.firstFooter = (FooterPart)part;
                if (titlePage == null || !titlePage.isVal()) continue;
                log.debug("setting first page footer");
                this.firstFooterActive = (FooterPart)part;
                continue;
            }
            if (footerReference.getType() == HdrFtrRef.EVEN) {
                log.debug("setting even page footer");
                this.evenFooter = (FooterPart)part;
                continue;
            }
            log.debug("setting default page footer");
            this.defaultFooter = (FooterPart)part;
        }
    }

    public HeaderPart getFirstHeader() {
        return this.firstHeaderActive;
    }

    public FooterPart getFirstFooter() {
        return this.firstFooterActive;
    }

    public HeaderPart getEvenHeader() {
        return this.evenHeader;
    }

    public FooterPart getEvenFooter() {
        return this.evenFooter;
    }

    public HeaderPart getDefaultHeader() {
        return this.defaultHeader;
    }

    public FooterPart getDefaultFooter() {
        return this.defaultFooter;
    }

    public HeaderPart getHeader(int pageNumber) {
        if (pageNumber == 1 && this.firstHeaderActive != null) {
            return this.firstHeaderActive;
        }
        if (pageNumber % 2 == 0 && this.evenHeader != null) {
            return this.evenHeader;
        }
        return this.defaultHeader;
    }

    public FooterPart getFooter(int pageNumber) {
        if (pageNumber == 1 && this.firstFooterActive != null) {
            return this.firstFooterActive;
        }
        if (pageNumber % 2 == 0 && this.evenFooter != null) {
            return this.evenFooter;
        }
        return this.defaultFooter;
    }
}

