/*
 * Decompiled with CFR 0.152.
 */
package org.antechrestos.restclienttest.context;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.antechrestos.restclienttest.context.Payload;
import org.antechrestos.restclienttest.utils.URIHelper;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public final class Context {
    private final HttpMethod method;
    private final Map<String, List<String>> queryParameters;
    private final HttpHeaders requestHeaders;
    private final byte[] requestPayload;
    private final HttpHeaders responseHeaders;
    private final byte[] responsePayload;
    private final HttpStatus statusCode;
    private final URI url;

    private static byte[] loadPayload(String path) {
        try {
            URL resourceUrl = ClassLoader.getSystemResource(path);
            if (resourceUrl == null) {
                throw new FileNotFoundException(path);
            }
            return Files.readAllBytes(Paths.get(resourceUrl.toURI()));
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void mergeMaps(Map<String, List<String>> container, Map<String, List<String>> other) {
        if (other != null) {
            other.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> container.merge((String)entry.getKey(), (List<String>)entry.getValue(), (alreadyExisting, otherList) -> {
                alreadyExisting.addAll(otherList);
                return alreadyExisting;
            }));
        }
    }

    Context(@NonNull String url, @NonNull HttpMethod method, @NonNull HttpStatus statusCode, Map<String, List<String>> queryParameters, Map<String, List<String>> requestHeaders, Map<String, List<String>> responseHeaders, Payload requestPayload, Payload responsePayload) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        if (statusCode == null) {
            throw new NullPointerException("statusCode");
        }
        URI urlTemp = URI.create(url);
        this.method = method;
        this.statusCode = statusCode;
        this.queryParameters = new HashMap<String, List<String>>();
        Context.mergeMaps(this.queryParameters, URIHelper.getQueryParameters(urlTemp));
        Context.mergeMaps(this.queryParameters, queryParameters);
        this.url = URIHelper.removeQueryParameters(urlTemp);
        this.requestHeaders = new HttpHeaders();
        this.requestHeaders.putAll(requestHeaders);
        this.responseHeaders = new HttpHeaders();
        this.responseHeaders.putAll(responseHeaders);
        if (requestPayload != null) {
            switch (requestPayload.getType()) {
                case RAW_STRING: {
                    this.requestPayload = requestPayload.getValue().getBytes();
                    break;
                }
                case CLASSPATH_RESOURCE: {
                    this.requestPayload = Context.loadPayload(requestPayload.getValue());
                    break;
                }
                default: {
                    this.requestPayload = null;
                    break;
                }
            }
        } else {
            this.requestPayload = null;
        }
        if (responsePayload != null) {
            switch (responsePayload.getType()) {
                case RAW_STRING: {
                    this.responsePayload = responsePayload.getValue().getBytes();
                    break;
                }
                case CLASSPATH_RESOURCE: {
                    this.responsePayload = Context.loadPayload(responsePayload.getValue());
                    break;
                }
                default: {
                    this.responsePayload = new byte[0];
                    break;
                }
            }
        } else {
            this.responsePayload = new byte[0];
        }
    }

    public static ContextBuilder builder() {
        return new ContextBuilder();
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Map<String, List<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public HttpHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    public byte[] getRequestPayload() {
        return this.requestPayload;
    }

    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public byte[] getResponsePayload() {
        return this.responsePayload;
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Context)) {
            return false;
        }
        Context other = (Context)o;
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Map<String, List<String>> this$queryParameters = this.getQueryParameters();
        Map<String, List<String>> other$queryParameters = other.getQueryParameters();
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        HttpHeaders this$requestHeaders = this.getRequestHeaders();
        HttpHeaders other$requestHeaders = other.getRequestHeaders();
        if (this$requestHeaders == null ? other$requestHeaders != null : !this$requestHeaders.equals(other$requestHeaders)) {
            return false;
        }
        if (!Arrays.equals(this.getRequestPayload(), other.getRequestPayload())) {
            return false;
        }
        HttpHeaders this$responseHeaders = this.getResponseHeaders();
        HttpHeaders other$responseHeaders = other.getResponseHeaders();
        if (this$responseHeaders == null ? other$responseHeaders != null : !this$responseHeaders.equals(other$responseHeaders)) {
            return false;
        }
        if (!Arrays.equals(this.getResponsePayload(), other.getResponsePayload())) {
            return false;
        }
        HttpStatus this$statusCode = this.getStatusCode();
        HttpStatus other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
            return false;
        }
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !((Object)this$url).equals(other$url));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Map<String, List<String>> $queryParameters = this.getQueryParameters();
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        HttpHeaders $requestHeaders = this.getRequestHeaders();
        result = result * 59 + ($requestHeaders == null ? 43 : $requestHeaders.hashCode());
        result = result * 59 + Arrays.hashCode(this.getRequestPayload());
        HttpHeaders $responseHeaders = this.getResponseHeaders();
        result = result * 59 + ($responseHeaders == null ? 43 : $responseHeaders.hashCode());
        result = result * 59 + Arrays.hashCode(this.getResponsePayload());
        HttpStatus $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        return result;
    }

    public String toString() {
        return "Context(method=" + this.getMethod() + ", queryParameters=" + this.getQueryParameters() + ", requestHeaders=" + this.getRequestHeaders() + ", requestPayload=" + Arrays.toString(this.getRequestPayload()) + ", responseHeaders=" + this.getResponseHeaders() + ", responsePayload=" + Arrays.toString(this.getResponsePayload()) + ", statusCode=" + this.getStatusCode() + ", url=" + this.getUrl() + ")";
    }

    public static class ContextBuilder {
        private String url;
        private HttpMethod method;
        private HttpStatus statusCode;
        private ArrayList<String> queryParameters$key;
        private ArrayList<List<String>> queryParameters$value;
        private ArrayList<String> requestHeaders$key;
        private ArrayList<List<String>> requestHeaders$value;
        private ArrayList<String> responseHeaders$key;
        private ArrayList<List<String>> responseHeaders$value;
        private Payload requestPayload;
        private Payload responsePayload;

        ContextBuilder() {
        }

        public ContextBuilder url(String url) {
            this.url = url;
            return this;
        }

        public ContextBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public ContextBuilder statusCode(HttpStatus statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public ContextBuilder queryParameter(String queryParameterKey, List<String> queryParameterValue) {
            if (this.queryParameters$key == null) {
                this.queryParameters$key = new ArrayList();
                this.queryParameters$value = new ArrayList();
            }
            this.queryParameters$key.add(queryParameterKey);
            this.queryParameters$value.add(queryParameterValue);
            return this;
        }

        public ContextBuilder queryParameters(Map<? extends String, ? extends List<String>> queryParameters) {
            if (this.queryParameters$key == null) {
                this.queryParameters$key = new ArrayList();
                this.queryParameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends List<String>> $lombokEntry : queryParameters.entrySet()) {
                this.queryParameters$key.add($lombokEntry.getKey());
                this.queryParameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ContextBuilder requestHeader(String requestHeaderKey, List<String> requestHeaderValue) {
            if (this.requestHeaders$key == null) {
                this.requestHeaders$key = new ArrayList();
                this.requestHeaders$value = new ArrayList();
            }
            this.requestHeaders$key.add(requestHeaderKey);
            this.requestHeaders$value.add(requestHeaderValue);
            return this;
        }

        public ContextBuilder requestHeaders(Map<? extends String, ? extends List<String>> requestHeaders) {
            if (this.requestHeaders$key == null) {
                this.requestHeaders$key = new ArrayList();
                this.requestHeaders$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends List<String>> $lombokEntry : requestHeaders.entrySet()) {
                this.requestHeaders$key.add($lombokEntry.getKey());
                this.requestHeaders$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ContextBuilder responseHeader(String responseHeaderKey, List<String> responseHeaderValue) {
            if (this.responseHeaders$key == null) {
                this.responseHeaders$key = new ArrayList();
                this.responseHeaders$value = new ArrayList();
            }
            this.responseHeaders$key.add(responseHeaderKey);
            this.responseHeaders$value.add(responseHeaderValue);
            return this;
        }

        public ContextBuilder responseHeaders(Map<? extends String, ? extends List<String>> responseHeaders) {
            if (this.responseHeaders$key == null) {
                this.responseHeaders$key = new ArrayList();
                this.responseHeaders$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends List<String>> $lombokEntry : responseHeaders.entrySet()) {
                this.responseHeaders$key.add($lombokEntry.getKey());
                this.responseHeaders$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ContextBuilder requestPayload(Payload requestPayload) {
            this.requestPayload = requestPayload;
            return this;
        }

        public ContextBuilder responsePayload(Payload responsePayload) {
            this.responsePayload = responsePayload;
            return this;
        }

        public Context build() {
            Map<String, List<String>> responseHeaders;
            Map<Object, Object> requestHeaders;
            Map<Object, Object> queryParameters;
            switch (this.queryParameters$key == null ? 0 : this.queryParameters$key.size()) {
                case 0: {
                    queryParameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    queryParameters = Collections.singletonMap(this.queryParameters$key.get(0), this.queryParameters$value.get(0));
                    break;
                }
                default: {
                    queryParameters = new LinkedHashMap(this.queryParameters$key.size() < 0x40000000 ? 1 + this.queryParameters$key.size() + (this.queryParameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.queryParameters$key.size(); ++$i) {
                        queryParameters.put(this.queryParameters$key.get($i), this.queryParameters$value.get($i));
                    }
                    queryParameters = Collections.unmodifiableMap(queryParameters);
                }
            }
            switch (this.requestHeaders$key == null ? 0 : this.requestHeaders$key.size()) {
                case 0: {
                    requestHeaders = Collections.emptyMap();
                    break;
                }
                case 1: {
                    requestHeaders = Collections.singletonMap(this.requestHeaders$key.get(0), this.requestHeaders$value.get(0));
                    break;
                }
                default: {
                    requestHeaders = new LinkedHashMap(this.requestHeaders$key.size() < 0x40000000 ? 1 + this.requestHeaders$key.size() + (this.requestHeaders$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.requestHeaders$key.size(); ++$i) {
                        requestHeaders.put(this.requestHeaders$key.get($i), this.requestHeaders$value.get($i));
                    }
                    requestHeaders = Collections.unmodifiableMap(requestHeaders);
                }
            }
            switch (this.responseHeaders$key == null ? 0 : this.responseHeaders$key.size()) {
                case 0: {
                    responseHeaders = Collections.emptyMap();
                    break;
                }
                case 1: {
                    responseHeaders = Collections.singletonMap(this.responseHeaders$key.get(0), this.responseHeaders$value.get(0));
                    break;
                }
                default: {
                    responseHeaders = new LinkedHashMap(this.responseHeaders$key.size() < 0x40000000 ? 1 + this.responseHeaders$key.size() + (this.responseHeaders$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.responseHeaders$key.size(); ++$i) {
                        responseHeaders.put(this.responseHeaders$key.get($i), this.responseHeaders$value.get($i));
                    }
                    responseHeaders = Collections.unmodifiableMap(responseHeaders);
                }
            }
            return new Context(this.url, this.method, this.statusCode, queryParameters, requestHeaders, responseHeaders, this.requestPayload, this.responsePayload);
        }

        public String toString() {
            return "Context.ContextBuilder(url=" + this.url + ", method=" + this.method + ", statusCode=" + this.statusCode + ", queryParameters$key=" + this.queryParameters$key + ", queryParameters$value=" + this.queryParameters$value + ", requestHeaders$key=" + this.requestHeaders$key + ", requestHeaders$value=" + this.requestHeaders$value + ", responseHeaders$key=" + this.responseHeaders$key + ", responseHeaders$value=" + this.responseHeaders$value + ", requestPayload=" + this.requestPayload + ", responsePayload=" + this.responsePayload + ")";
        }
    }
}

