/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.Closer;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.sender.AbstractNioSender;
import biz.paluch.logging.gelf.intern.sender.GelfBuffers;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public class GelfUDPSender
extends AbstractNioSender<DatagramChannel>
implements GelfSender {
    private final Object ioLock = new Object();
    private final ThreadLocal<ByteBuffer> writeBuffers = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocateDirect(AbstractNioSender.INITIAL_BUFFER_SIZE);
        }
    };
    private final ThreadLocal<ByteBuffer> tempBuffers = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocateDirect(AbstractNioSender.INITIAL_BUFFER_SIZE);
        }
    };

    public GelfUDPSender(String host, int port, ErrorReporter errorReporter) throws IOException {
        super(errorReporter, host, port);
        this.connect();
    }

    @Override
    public boolean sendMessage(GelfMessage message) {
        if (INITIAL_BUFFER_SIZE == 0) {
            return this.sendDatagrams(message.toUDPBuffers());
        }
        return this.sendDatagrams(GelfBuffers.toUDPBuffers(message, this.writeBuffers, this.tempBuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendDatagrams(ByteBuffer[] bytesList) {
        try {
            if (!this.isConnected()) {
                Object object = this.ioLock;
                synchronized (object) {
                    this.connect();
                }
            }
            for (ByteBuffer buffer : bytesList) {
                Object object = this.ioLock;
                synchronized (object) {
                    while (buffer.hasRemaining()) {
                        ((DatagramChannel)this.channel()).write(buffer);
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.reportError(iOException.getMessage(), new IOException("Cannot send data to " + this.getHost() + ":" + this.getPort(), iOException));
            return false;
        }
        return true;
    }

    protected void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        if (this.channel() == null) {
            this.setChannel(DatagramChannel.open());
        } else if (!((DatagramChannel)this.channel()).isOpen()) {
            Closer.close(this.channel());
            this.setChannel(DatagramChannel.open());
        }
        ((DatagramChannel)this.channel()).configureBlocking(false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getHost(), this.getPort());
        try {
            DatagramChannel connect = ((DatagramChannel)this.channel()).connect(inetSocketAddress);
            this.setChannel(connect);
        }
        catch (SocketException e) {
            this.reportError(e.getMessage(), e);
        }
    }

    @Override
    protected boolean isConnected(DatagramChannel channel) {
        return channel.isConnected();
    }
}

