/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.svg;

import java.util.ArrayList;
import java.util.Iterator;
import net.arnx.wmf2svg.gdi.GdiFont;
import net.arnx.wmf2svg.gdi.GdiUtils;
import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.svg.SvgObject;
import org.w3c.dom.Text;

class SvgFont
extends SvgObject
implements GdiFont {
    private int height;
    private int width;
    private int escapement;
    private int orientation;
    private int weight;
    private boolean italic;
    private boolean underline;
    private boolean strikeout;
    private int charset;
    private int outPrecision;
    private int clipPrecision;
    private int quality;
    private int pitchAndFamily;
    private String faceName;
    private double heightMultiply = 1.0;
    private String lang;

    public SvgFont(SvgGdi gdi, int height, int width, int escapement, int orientation, int weight, boolean italic, boolean underline, boolean strikeout, int charset, int outPrecision, int clipPrecision, int quality, int pitchAndFamily, byte[] faceName) {
        super(gdi);
        String alter;
        this.height = height;
        this.width = width;
        this.escapement = escapement;
        this.orientation = orientation;
        this.weight = weight;
        this.italic = italic;
        this.underline = underline;
        this.strikeout = strikeout;
        this.charset = charset;
        this.outPrecision = outPrecision;
        this.clipPrecision = clipPrecision;
        this.quality = quality;
        this.pitchAndFamily = pitchAndFamily;
        this.faceName = GdiUtils.convertString(faceName, charset);
        this.lang = GdiUtils.getLanguage(charset);
        String emheight = gdi.getProperty("font-emheight." + this.faceName);
        if (emheight == null && (alter = gdi.getProperty("alternative-font." + this.faceName)) != null) {
            emheight = gdi.getProperty("font-emheight." + alter);
        }
        if (emheight != null) {
            this.heightMultiply = Double.parseDouble(emheight);
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getEscapement() {
        return this.escapement;
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public boolean isItalic() {
        return this.italic;
    }

    @Override
    public boolean isUnderlined() {
        return this.underline;
    }

    @Override
    public boolean isStrikedOut() {
        return this.strikeout;
    }

    @Override
    public int getCharset() {
        return this.charset;
    }

    @Override
    public int getOutPrecision() {
        return this.outPrecision;
    }

    @Override
    public int getClipPrecision() {
        return this.clipPrecision;
    }

    @Override
    public int getQuality() {
        return this.quality;
    }

    @Override
    public int getPitchAndFamily() {
        return this.pitchAndFamily;
    }

    @Override
    public String getFaceName() {
        return this.faceName;
    }

    public String getLang() {
        return this.lang;
    }

    public int[] validateDx(byte[] chars, int[] dx) {
        if (dx == null || dx.length == 0) {
            return null;
        }
        int[][] area = GdiUtils.getFirstByteArea(this.charset);
        if (area == null) {
            return dx;
        }
        int n = 0;
        boolean skip = false;
        for (int i = 0; i < chars.length && i < dx.length; ++i) {
            int c = 0xFF & chars[i];
            if (skip) {
                int n2 = n - 1;
                dx[n2] = dx[n2] + dx[i];
                skip = false;
                continue;
            }
            for (int j = 0; j < area.length; ++j) {
                if (area[j][0] > c || c > area[j][1]) continue;
                skip = true;
                break;
            }
            dx[n++] = dx[i];
        }
        int[] ndx = new int[n];
        System.arraycopy(dx, 0, ndx, 0, n);
        return ndx;
    }

    public int getFontSize() {
        return Math.abs((int)this.getGDI().getDC().toRelativeY((double)this.height * this.heightMultiply));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.charset;
        result = 31 * result + this.clipPrecision;
        result = 31 * result + this.escapement;
        result = 31 * result + (this.faceName == null ? 0 : this.faceName.hashCode());
        result = 31 * result + this.height;
        result = 31 * result + (this.italic ? 1231 : 1237);
        result = 31 * result + this.orientation;
        result = 31 * result + this.outPrecision;
        result = 31 * result + this.pitchAndFamily;
        result = 31 * result + this.quality;
        result = 31 * result + (this.strikeout ? 1231 : 1237);
        result = 31 * result + (this.underline ? 1231 : 1237);
        result = 31 * result + this.weight;
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SvgFont other = (SvgFont)obj;
        if (this.charset != other.charset) {
            return false;
        }
        if (this.clipPrecision != other.clipPrecision) {
            return false;
        }
        if (this.escapement != other.escapement) {
            return false;
        }
        if (this.faceName == null ? other.faceName != null : !this.faceName.equals(other.faceName)) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (this.italic != other.italic) {
            return false;
        }
        if (this.orientation != other.orientation) {
            return false;
        }
        if (this.outPrecision != other.outPrecision) {
            return false;
        }
        if (this.pitchAndFamily != other.pitchAndFamily) {
            return false;
        }
        if (this.quality != other.quality) {
            return false;
        }
        if (this.strikeout != other.strikeout) {
            return false;
        }
        if (this.underline != other.underline) {
            return false;
        }
        if (this.weight != other.weight) {
            return false;
        }
        return this.width == other.width;
    }

    public Text createTextNode(String id) {
        return this.getGDI().getDocument().createTextNode("." + id + " { " + this.toString() + " }\n");
    }

    public String toString() {
        int fontSize;
        StringBuffer buffer = new StringBuffer();
        if (this.italic) {
            buffer.append("font-style: italic; ");
        }
        if (this.weight != 0 && this.weight != 400) {
            this.weight = this.weight < 100 ? 100 : (this.weight > 900 ? 900 : this.weight / 100 * 100);
            if (this.weight == 700) {
                buffer.append("font-weight: bold; ");
            } else {
                buffer.append("font-weight: " + this.weight + "; ");
            }
        }
        if ((fontSize = this.getFontSize()) != 0) {
            buffer.append("font-size: ").append(fontSize).append("px; ");
        }
        ArrayList<String> fontList = new ArrayList<String>();
        if (this.faceName.length() != 0) {
            String fontFamily = this.faceName;
            if (this.faceName.charAt(0) == '@') {
                fontFamily = this.faceName.substring(1);
            }
            fontList.add(fontFamily);
            String altfont = this.getGDI().getProperty("alternative-font." + fontFamily);
            if (altfont != null && altfont.length() != 0) {
                fontList.add(altfont);
            }
        }
        int family = this.pitchAndFamily & 0xF0;
        switch (family) {
            case 80: {
                fontList.add("fantasy");
                break;
            }
            case 48: {
                fontList.add("monospace");
                break;
            }
            case 16: {
                fontList.add("serif");
                break;
            }
            case 64: {
                fontList.add("cursive");
                break;
            }
            case 32: {
                fontList.add("sans-serif");
            }
        }
        if (!fontList.isEmpty()) {
            buffer.append("font-family:");
            boolean isVertical = false;
            Iterator i = fontList.iterator();
            while (i.hasNext()) {
                String font = (String)i.next();
                if (font.indexOf(" ") != -1) {
                    buffer.append(" \"" + font + "\"");
                } else {
                    buffer.append(" " + font);
                }
                if (!i.hasNext()) continue;
                buffer.append(",");
            }
            buffer.append("; ");
        }
        if (this.underline || this.strikeout) {
            buffer.append("text-decoration:");
            if (this.underline) {
                buffer.append(" underline");
            }
            if (this.strikeout) {
                buffer.append(" overline");
            }
            buffer.append("; ");
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

