/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.repo;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.InputStream;
import java.util.UUID;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.qubership.atp.ei.node.config.GridFsConfiguration;
import org.springframework.core.io.InputStreamResource;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class GridFsRepository {
    private final GridFsTemplate eiGridFsTemplate;

    public GridFsRepository(GridFsConfiguration.GridFsProvider eiGridFsTemplate) {
        this.eiGridFsTemplate = eiGridFsTemplate.getGridFsTemplate();
    }

    public ObjectId store(InputStream fileInputStream, String fileName, String contentType, String processId) {
        Document document = new Document();
        document.append("processId", (Object)UUID.fromString(processId));
        document.append("originalName", (Object)fileName);
        return this.eiGridFsTemplate.store(fileInputStream, processId + "_" + fileName, contentType, document);
    }

    public GridFSFile findOne(ObjectId objectId) {
        return this.eiGridFsTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)objectId)));
    }

    public InputStreamResource getResourceById(ObjectId objectId) {
        return this.eiGridFsTemplate.getResource(this.findOne(objectId));
    }
}

