/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.util.concurrent.Callable;
import org.powermock.core.InvocationException;

public class ClassloaderWrapper {
    public static void runWithClass(Runnable runnable) {
        ClassloaderWrapper.runWithClassClassLoader(ClassloaderWrapper.class.getClassLoader(), runnable);
    }

    public static void runWithClassClassLoader(ClassLoader classLoader, Runnable runnable) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    public static <V> V runWithClass(Callable<V> callable) {
        return ClassloaderWrapper.runWithClassClassLoader(ClassloaderWrapper.class.getClassLoader(), callable);
    }

    public static <V> V runWithClassClassLoader(ClassLoader classLoader, Callable<V> callable) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            V v = callable.call();
            return v;
        }
        catch (Exception e) {
            throw new InvocationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }
}

