/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.controllers;

import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import java.text.ParseException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.tdm.model.refresh.RefreshResults;
import org.qubership.atp.tdm.model.refresh.TestDataRefreshConfig;
import org.qubership.atp.tdm.service.DataRefreshService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/tdm/data/refresh"})
@RestController
public class DataRefreshController {
    private final DataRefreshService dataRefreshService;

    @Autowired
    public DataRefreshController(@Nonnull DataRefreshService dataRefreshService) {
        this.dataRefreshService = dataRefreshService;
    }

    @Operation(description="Get refresh configuration for specified dataset / table ID.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByRefreshConfigId(#id).getProjectId(), 'READ')")
    @AuditAction(auditAction="Get refresh configuration by id {{#id}}")
    @GetMapping(path={"/config/{id}"})
    public ResponseEntity<TestDataRefreshConfig> getRefreshConfig(@PathVariable UUID id) {
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)this.dataRefreshService.getRefreshConfig(id));
    }

    @Operation(description="Save / update data refresh settings.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#tableName).getProjectId(), 'CREATE')")
    @AuditAction(auditAction="Save / update data refresh settings. Table {{#tableName}}")
    @PostMapping(value={"/config"})
    public TestDataRefreshConfig saveRefreshConfig(@RequestParam(value="tableName") String tableName, @RequestParam Integer queryTimeout, @RequestBody TestDataRefreshConfig refreshConfig) throws Exception {
        return this.dataRefreshService.saveRefreshConfig(tableName, queryTimeout, refreshConfig);
    }

    @Operation(description="Force run data refresh.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#tableName).getProjectId(), 'CREATE')")
    @AuditAction(auditAction="Force run data refresh. Table {{#tableName}}")
    @PostMapping(value={"/run"})
    public List<RefreshResults> runDataRefresh(@RequestParam(value="tableName") String tableName, @RequestParam Integer queryTimeout, @RequestParam boolean allEnv) throws Exception {
        return this.dataRefreshService.runRefresh(tableName, queryTimeout, allEnv, false);
    }

    @Operation(description="Get next run's date / time details.")
    @AuditAction(auditAction="Get next run's date. cron {{#cronExpression}}")
    @GetMapping(value={"/next/run"})
    public ResponseEntity<String> getNextScheduledRun(@RequestParam(value="cronExpression") String cronExpression) throws ParseException {
        return ResponseEntity.ok((Object)new Gson().toJson((Object)this.dataRefreshService.getNextScheduledRun(cronExpression)));
    }
}

