/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.tdm.controllers.api.dto.testdata.ChangeTitleRequestDto;
import org.qubership.atp.tdm.controllers.api.dto.testdata.ColumnValuesDto;
import org.qubership.atp.tdm.controllers.api.dto.testdata.EnvsListDto;
import org.qubership.atp.tdm.controllers.api.dto.testdata.ImportTestDataStatisticDto;
import org.qubership.atp.tdm.controllers.api.dto.testdata.TestDataFlagsTableDto;
import org.qubership.atp.tdm.controllers.api.dto.testdata.TestDataRequestDto;
import org.qubership.atp.tdm.controllers.api.dto.testdata.TestDataTableCatalogDto;
import org.qubership.atp.tdm.controllers.api.dto.testdata.TestDataTableDto;
import org.qubership.atp.tdm.controllers.api.dto.testdata.TestDataTableUpdateByQueryDto;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="TestDataController", description="Test Data Controller")
public interface TestDataControllerApi {
    @Operation(operationId="alterCreatedWhenColumn", summary="Old update.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/alter/created/when"})
    public ResponseEntity<Void> alterCreatedWhenColumn();

    @Operation(operationId="alterOccupiedByColumn", summary="Old update.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/fix/occupied/by/column"})
    public ResponseEntity<Void> alterOccupiedByColumn();

    @Operation(operationId="alterOccupyStatistic", summary="Old update.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/alter/occupy/statistic"})
    public ResponseEntity<Void> alterOccupyStatistic();

    @Operation(operationId="changeTestDataTitle", summary="Changes table title.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/tdm/change/title"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Boolean> changeTestDataTitle(@Parameter(name="ChangeTitleRequestDto", description="") @Valid @RequestBody(required=false) ChangeTitleRequestDto var1);

    @Operation(operationId="deleteTestData", summary="Drop selected table.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/tdm/table"})
    public ResponseEntity<Void> deleteTestData(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1);

    @Operation(operationId="deleteTestDataTableRows", summary="Delete selected rows from table.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/tdm/delete/rows"}, consumes={"application/json"})
    public ResponseEntity<Void> deleteTestDataTableRows(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var2);

    @Operation(operationId="evaluateQuery", summary="evaluateQuery", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/tdm/evaluate/query"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Map<String, String>> evaluateQuery(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var2);

    @Operation(operationId="fillEnvIdColumn", summary="Old update.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/fill/envId"})
    public ResponseEntity<Void> fillEnvIdColumn();

    @Operation(operationId="getColumnDistinctValues", summary="Get column distinct values.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ColumnValuesDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/table/column/distinct/values"}, produces={"application/json"})
    public ResponseEntity<ColumnValuesDto> getColumnDistinctValues(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1, @NotNull @Parameter(name="columnName", description="columnName", required=true) @Valid @RequestParam(value="columnName", required=true) String var2, @NotNull @Parameter(name="occupied", description="occupied", required=true) @Valid @RequestParam(value="occupied", required=true) Boolean var3);

    @Operation(operationId="getDistinctColumnValues", summary="Get all distinct values by system_id and column_name", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ColumnValuesDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/data/available/recalculate"}, produces={"application/json"})
    public ResponseEntity<ColumnValuesDto> getDistinctColumnValues(@NotNull @Parameter(name="systemId", description="systemId", required=true) @Valid @RequestParam(value="systemId", required=true) String var1, @NotNull @Parameter(name="columnName", description="columnName", required=true) @Valid @RequestParam(value="columnName", required=true) String var2);

    @Operation(operationId="getPreviewLink", summary="Get preview for linker.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/link/preview"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> getPreviewLink(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="systemId", description="systemId", required=true) @Valid @RequestParam(value="systemId", required=true) UUID var2, @NotNull @Parameter(name="columnName", description="columnName", required=true) @Valid @RequestParam(value="columnName", required=true) String var3, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var4);

    @Operation(operationId="getTableEnvironments", summary="Returns a list of environment IDs that have tables with the requested table title for the specified project.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvsListDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/table/environments"}, produces={"application/json"})
    public ResponseEntity<EnvsListDto> getTableEnvironments(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="tableTitle", description="tableTitle", required=true) @Valid @RequestParam(value="tableTitle", required=true) String var2);

    @Operation(operationId="getTableRow", summary="Get row value.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/table/row"}, produces={"application/json"})
    public ResponseEntity<Object> getTableRow(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="tableTitle", description="tableTitle", required=true) @Valid @RequestParam(value="tableTitle", required=true) String var2, @NotNull @Parameter(name="columnName", description="columnName", required=true) @Valid @RequestParam(value="columnName", required=true) String var3, @NotNull @Parameter(name="searchValue", description="searchValue", required=true) @Valid @RequestParam(value="searchValue", required=true) String var4, @Parameter(name="systemId", description="systemId") @Valid @RequestParam(value="systemId", required=false) UUID var5, @Parameter(name="occupied", description="occupied") @Valid @RequestParam(value="occupied", required=false) Boolean var6);

    @Operation(operationId="getTestData", summary="Get test data table.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestDataTableDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/table"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TestDataTableDto> getTestData(@Parameter(name="TestDataRequestDto", description="") @Valid @RequestBody(required=false) TestDataRequestDto var1);

    @Operation(operationId="getTestDataTableAsCsvFile", summary="Download table as csv file.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/csv", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/download/csv"}, produces={"text/csv"})
    public ResponseEntity<Resource> getTestDataTableAsCsvFile(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1);

    @Operation(operationId="getTestDataTableAsExcelFile", summary="Download table as excel file.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/download/excel"}, produces={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public ResponseEntity<Resource> getTestDataTableAsExcelFile(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1);

    @Operation(operationId="getTestDataTablesCatalog", summary="Get test data tables catalog.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestDataTableCatalogDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/tables/catalog"}, produces={"application/json"})
    public ResponseEntity<List<TestDataTableCatalogDto>> getTestDataTablesCatalog(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @Parameter(name="systemId", description="systemId") @Valid @RequestParam(value="systemId", required=false) UUID var2);

    @Operation(operationId="getTestDataTablesList", summary="Get tables under project.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/tables/list"}, produces={"application/json"})
    public ResponseEntity<List<String>> getTestDataTablesList(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1);

    @Operation(operationId="getTestDataTablesListByEnvironment", summary="Get tables id and name under project and environment.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/environment/tables/list"}, produces={"application/json"})
    public ResponseEntity<String> getTestDataTablesListByEnvironment(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="envId", description="envId", required=true) @Valid @RequestParam(value="envId", required=true) UUID var2);

    @Operation(operationId="importExcelTestData", summary="Import excel to TDM.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ImportTestDataStatisticDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/import/excel"}, produces={"application/json"}, consumes={"application/json", "application/octet-stream"})
    public ResponseEntity<List<ImportTestDataStatisticDto>> importExcelTestData(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="tableTitle", description="tableTitle", required=true) @Valid @RequestParam(value="tableTitle", required=true) String var2, @NotNull @Parameter(name="runSqlScript", description="runSqlScript", required=true) @Valid @RequestParam(value="runSqlScript", required=true) Boolean var3, @Parameter(name="environmentId", description="environmentId") @Valid @RequestParam(value="environmentId", required=false) UUID var4, @Parameter(name="systemId", description="systemId") @Valid @RequestParam(value="systemId", required=false) UUID var5, @Parameter(name="body", description="") @Valid @RequestBody(required=false) Resource var6);

    @Operation(operationId="importSqlTestData", summary="Import sql to TDM.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ImportTestDataStatisticDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/import/sql"}, produces={"application/json"})
    public ResponseEntity<List<ImportTestDataStatisticDto>> importSqlTestData(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="environmentsIds", description="environmentsIds", required=true) @Valid @RequestParam(value="environmentsIds", required=true) UUID var2, @NotNull @Parameter(name="systemName", description="systemName", required=true) @Valid @RequestParam(value="systemName", required=true) String var3, @NotNull @Parameter(name="tableTitle", description="tableTitle", required=true) @Valid @RequestParam(value="tableTitle", required=true) String var4, @NotNull @Parameter(name="query", description="query", required=true) @Valid @RequestParam(value="query", required=true) String var5, @NotNull @Parameter(name="queryTimeout", description="queryTimeout", required=true) @Valid @RequestParam(value="queryTimeout", required=true) Integer var6);

    @Operation(operationId="isUnoccupiedValidation", summary="Check flag 'is unoccupied validation'.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestDataFlagsTableDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/validation/unoccupied"}, produces={"application/json"})
    public ResponseEntity<TestDataFlagsTableDto> isUnoccupiedValidation(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1);

    @Operation(operationId="occupyTestData", summary="Occupy test data.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/tdm/occupy"}, consumes={"application/json"})
    public ResponseEntity<Void> occupyTestData(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1, @NotNull @Parameter(name="occupiedBy", description="occupiedBy", required=true) @Valid @RequestParam(value="occupiedBy", required=true) String var2, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var3);

    @Operation(operationId="releaseTestData", summary="Release test data.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/tdm/release"}, consumes={"application/json"})
    public ResponseEntity<Void> releaseTestData(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var2);

    @Operation(operationId="resolveDiscrepancyTestDataFlagsTableAndTestDataTableCatalog", summary="Resolve discrepancy TestDataFlagsTable and TestDataTableCatalog.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/resolve/discrepancy/testDataFlagsTableAndTestDataTableCatalog"})
    public ResponseEntity<Void> resolveDiscrepancyTestDataFlagsTableAndTestDataTableCatalog();

    @Operation(operationId="setupColumnLinks", summary="Setup links.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/link/setup"}, consumes={"application/json"})
    public ResponseEntity<Void> setupColumnLinks(@NotNull @Parameter(name="isAll", description="isAll", required=true) @Valid @RequestParam(value="isAll", required=true) Boolean var1, @NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var2, @NotNull @Parameter(name="systemId", description="systemId", required=true) @Valid @RequestParam(value="systemId", required=true) UUID var3, @NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var4, @NotNull @Parameter(name="columnName", description="columnName", required=true) @Valid @RequestParam(value="columnName", required=true) String var5, @NotNull @Parameter(name="validateUnoccupiedResources", description="validateUnoccupiedResources", required=true) @Valid @RequestParam(value="validateUnoccupiedResources", required=true) Boolean var6, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var7);

    @Operation(operationId="truncateDataInTable", summary="Truncate data in table.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/tdm/truncate/table"}, produces={"application/json"})
    public ResponseEntity<String> truncateDataInTable(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1, @NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var2, @Parameter(name="systemId", description="systemId") @Valid @RequestParam(value="systemId", required=false) UUID var3);

    @Operation(operationId="updateTableBySql", summary="Update existing table by sql.", tags={"test-data-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ImportTestDataStatisticDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/update/sql"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ImportTestDataStatisticDto> updateTableBySql(@Parameter(name="TestDataTableUpdateByQueryDto", description="") @Valid @RequestBody(required=false) TestDataTableUpdateByQueryDto var1);
}

