/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import brave.spring.rabbit.SpringRabbitTracing;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SleuthRabbitBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;
    private SpringRabbitTracing tracing;

    public SleuthRabbitBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RabbitTemplate) {
            return this.rabbitTracing().decorateRabbitTemplate((RabbitTemplate)bean);
        }
        if (bean instanceof SimpleRabbitListenerContainerFactory) {
            return this.rabbitTracing().decorateSimpleRabbitListenerContainerFactory((SimpleRabbitListenerContainerFactory)bean);
        }
        if (bean instanceof DirectRabbitListenerContainerFactory) {
            return this.rabbitTracing().decorateDirectRabbitListenerContainerFactory((DirectRabbitListenerContainerFactory)bean);
        }
        if (bean instanceof SimpleMessageListenerContainer || bean instanceof DirectMessageListenerContainer) {
            return this.rabbitTracing().decorateMessageListenerContainer((AbstractMessageListenerContainer)bean);
        }
        return bean;
    }

    SpringRabbitTracing rabbitTracing() {
        if (this.tracing == null) {
            this.tracing = (SpringRabbitTracing)this.beanFactory.getBean(SpringRabbitTracing.class);
        }
        return this.tracing;
    }
}

