/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave.instrument.reactor.netty;

import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import io.netty.channel.ChannelHandler;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.cloud.gateway.config.HttpClientCustomizer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.brave.instrument.reactor.netty.TracingChannelInboundHandler;
import org.springframework.cloud.sleuth.brave.instrument.reactor.netty.TracingChannelOutboundHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.netty.http.brave.ReactorNettyHttpTracing;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.server.HttpServer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={HttpTracing.class, ReactorNettyHttpTracing.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class BraveReactorNettyAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.reactor.netty.debug.enabled"})
    @ConditionalOnBean(value={HttpTracing.class})
    static class DebugReactorNettyConfiguration {
        static final String INBOUND_NAME = "reactor.left.customTracingChannelInboundHandler";
        static final String OUTBOUND_NAME = "reactor.right.customTracingChannelOutboundHandler";

        DebugReactorNettyConfiguration() {
        }

        @Bean
        public NettyServerCustomizer tracingNettyServerCustomizer(HttpTracing httpTracing) {
            return server -> (HttpServer)ReactorNettyHttpTracing.create((HttpTracing)httpTracing).decorateHttpServer(server).doOnChannelInit((obs, ch, addr) -> {
                CurrentTraceContext currentTraceContext = httpTracing.tracing().currentTraceContext();
                String oldNameInboundHandler = "reactor.left.tracingChannelInboundHandler";
                ch.pipeline().remove(oldNameInboundHandler);
                ch.pipeline().addFirst(INBOUND_NAME, (ChannelHandler)new TracingChannelInboundHandler(currentTraceContext));
                String oldNameOutboundHandler = "reactor.right.tracingChannelOutboundHandler";
                ch.pipeline().replace(oldNameOutboundHandler, OUTBOUND_NAME, (ChannelHandler)new TracingChannelOutboundHandler(currentTraceContext));
            });
        }

        @Bean
        public HttpClientCustomizer tracingHttpClientCustomizer(HttpTracing httpTracing) {
            return client -> (HttpClient)client.doOnChannelInit((obs, ch, addr) -> {
                CurrentTraceContext currentTraceContext = httpTracing.tracing().currentTraceContext();
                ch.pipeline().addFirst(INBOUND_NAME, (ChannelHandler)new TracingChannelInboundHandler(currentTraceContext));
                ch.pipeline().addBefore("reactor.right.reactiveBridge", OUTBOUND_NAME, (ChannelHandler)new TracingChannelOutboundHandler(currentTraceContext));
            });
        }
    }
}

