/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.zipkin2;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinSenderCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import zipkin2.reporter.Sender;
import zipkin2.reporter.activemq.ActiveMQSender;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ActiveMQConnectionFactory.class})
@ConditionalOnMissingBean(name={"zipkinSender"})
@Conditional(value={ZipkinSenderCondition.class})
@ConditionalOnProperty(value={"spring.zipkin.sender.type"}, havingValue="activemq")
@AutoConfigureAfter(value={ActiveMQAutoConfiguration.class})
class ZipkinActiveMqSenderConfiguration {
    ZipkinActiveMqSenderConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={ActiveMQConnectionFactory.class})
    static class ZipkinActiveMqSenderBeanConfiguration {
        @Value(value="${spring.zipkin.activemq.queue:zipkin}")
        private String queue;
        @Value(value="${spring.zipkin.activemq.message-max-bytes:100000}")
        private int messageMaxBytes;

        ZipkinActiveMqSenderBeanConfiguration() {
        }

        @Bean(value={"zipkinSender"})
        Sender activeMqSender(ActiveMQConnectionFactory factory) {
            return ActiveMQSender.newBuilder().connectionFactory(factory).messageMaxBytes(this.messageMaxBytes).queue(this.queue).build();
        }
    }
}

