/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.security.oauth2.client.relay;

import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.qubership.atp.auth.springbootstarter.security.oauth2.client.relay.TokenRelayException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class TokenRelayKeycloakClientContext
extends DefaultOAuth2ClientContext {
    public TokenRelayKeycloakClientContext(AccessTokenRequest accessTokenRequest) {
        super(accessTokenRequest);
    }

    public OAuth2AccessToken getAccessToken() {
        return this.changeTokenType(this.extractAccessToken(SecurityContextHolder.getContext().getAuthentication()));
    }

    private OAuth2AccessToken extractAccessToken(Authentication authentication) {
        if (authentication == null) {
            throw new TokenRelayException("Unable extract token, authentication is null");
        }
        if (authentication instanceof KeycloakAuthenticationToken) {
            KeycloakPrincipal principal = (KeycloakPrincipal)authentication.getPrincipal();
            KeycloakSecurityContext securityContext = principal.getKeycloakSecurityContext();
            String token = securityContext.getTokenString();
            return new DefaultOAuth2AccessToken(token);
        }
        throw new TokenRelayException("Unable extract token from authentication of type " + authentication.getClass().getName());
    }

    private OAuth2AccessToken changeTokenType(OAuth2AccessToken accessToken) {
        if (accessToken != null && "bearer".equals(accessToken.getTokenType())) {
            DefaultOAuth2AccessToken fixedToken = new DefaultOAuth2AccessToken(accessToken);
            fixedToken.setTokenType("Bearer");
            return fixedToken;
        }
        return accessToken;
    }
}

