/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.services;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.entities.Group;
import org.qubership.atp.auth.springbootstarter.entities.Project;
import org.qubership.atp.auth.springbootstarter.holders.DataContextHolder;
import org.qubership.atp.auth.springbootstarter.services.UsersService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupService {
    private static final Logger log = LoggerFactory.getLogger(UserGroupService.class);
    private final DataContextHolder<UUID> userIdContextHolder;
    private final UsersService usersService;
    private final DataContextHolder<Set<String>> userRolesContextHolder;

    public UserGroupService(DataContextHolder<UUID> userIdContextHolder, UsersService usersService, DataContextHolder<Set<String>> userRolesContextHolder) {
        this.userIdContextHolder = userIdContextHolder;
        this.usersService = usersService;
        this.userRolesContextHolder = userRolesContextHolder;
    }

    public Group getUserGroupByProjectId(UUID projectId) {
        Project project = this.usersService.getUsersByProject(projectId);
        log.debug("getUserGroupByProjectId: id = {}, project = {}", (Object)projectId, (Object)project);
        return this.getUserGroupByProject(project);
    }

    public Group getUserGroupByProject(Project project) {
        Optional<UUID> userId = this.userIdContextHolder.get();
        Set userRoles = this.userRolesContextHolder.get().orElse(null);
        if (userId.isPresent()) {
            return project.getUserGroup(userId.get(), userRoles);
        }
        return Group.DEFAULT;
    }

    public Optional<UUID> getUserId() {
        return this.userIdContextHolder.get();
    }
}

