/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.controllers;

import java.util.List;
import org.qubership.atp.ei.ntt.controllers.AbstractTreeNodeController;
import org.qubership.atp.ei.ntt.model.DataSet;
import org.qubership.atp.ei.ntt.model.ModelItem;
import org.qubership.atp.ei.ntt.model.Project;
import org.qubership.atp.ei.ntt.model.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelItemController
extends AbstractTreeNodeController {
    private static final Logger log = LoggerFactory.getLogger(ModelItemController.class);
    private static ModelItemController instance = null;

    private ModelItemController() {
    }

    public static synchronized ModelItemController getInstance() {
        if (instance == null) {
            instance = new ModelItemController();
        }
        return instance;
    }

    public <T extends TreeNode> T createSomeThing(Class<T> clazz, String name, Object ... helpArgs) {
        return this.create(clazz, name, helpArgs);
    }

    public void calculateNewNodeName(TreeNode node, TreeNode parent, Object ... helpArgs) {
        String newName;
        List<Object> nodeList;
        String prefix;
        if (parent == null) {
            return;
        }
        if (node instanceof DataSet) {
            String name = parent.getName() == null ? "default" : parent.getName();
            prefix = name + ".DataSet";
            nodeList = ((Project)parent).getDataSets();
        } else {
            prefix = this.getDefaultChildPrefix(parent);
            nodeList = parent.getChildren();
        }
        if (helpArgs != null && helpArgs.length > 0 && helpArgs[0] instanceof Integer) {
            newName = prefix + '.' + helpArgs[0];
        } else {
            boolean unique;
            int index = 1;
            block0: do {
                newName = prefix + '.' + index;
                unique = true;
                for (TreeNode treeNode : nodeList) {
                    if (!newName.equals(treeNode.getName())) continue;
                    ++index;
                    unique = false;
                    continue block0;
                }
            } while (!unique);
        }
        node.setName(newName);
    }

    public String getDefaultChildPrefix(TreeNode parent) {
        if (parent instanceof ModelItem) {
            return ((ModelItem)parent).getModelItemType().next().getName();
        }
        return null;
    }
}

