/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.scope;

import java.io.File;
import java.util.List;
import org.qubership.atp.ei.ntt.model.Scope;
import org.qubership.atp.ei.ntt.model.ScopeItem;
import org.qubership.atp.ei.ntt.scope.ModelItemNameToPathConverter;
import org.qubership.atp.ei.ntt.scope.ScopeDao;
import org.qubership.atp.ei.ntt.scope.ScopeItemDao;
import org.qubership.atp.ei.ntt.utils.CommonUtils;

public class ScopeDaoFactory {
    private static ScopeDaoFactory ourInstance = new ScopeDaoFactory();

    public static ScopeDaoFactory getInstance() {
        return ourInstance;
    }

    private ScopeDaoFactory() {
    }

    public ScopeDao getScopeDao(Scope scope) {
        ScopeDao result = new ScopeDao();
        result.setName(scope.getName());
        result.setDescription(scope.getDescription());
        List<ScopeItem> items = scope.getScopeItems();
        for (ScopeItem item : items) {
            ScopeItemDao scopeItem = new ScopeItemDao();
            scopeItem.setUuid(item.getId().toString());
            scopeItem.setModelItem("");
            if (item.getDataSet() != null) {
                scopeItem.setDataSet(item.getDataSet().getName());
            }
            if (item.getDependency() != null) {
                scopeItem.setBlockedBy(item.getDependency().getId().toString());
            }
            scopeItem.setStage(item.getStage().toString());
            scopeItem.setCountLimit(String.valueOf(item.getCountLimit()));
            scopeItem.setServer("");
            scopeItem.setTestSuite(ModelItemNameToPathConverter.extractTestSuite(item.getModelItem()));
            scopeItem.setTestCase(ModelItemNameToPathConverter.extractTestCase(item.getModelItem()));
            scopeItem.setTestStep(ModelItemNameToPathConverter.extractTestStep(item.getModelItem()));
            String projectFileName = CommonUtils.getSafeFilename(item.getProject().getName());
            scopeItem.setProject("." + File.separatorChar + "AT_configuration" + File.separatorChar + projectFileName + ".cpr");
            result.getScopeItems().add(scopeItem);
        }
        return result;
    }
}

