/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    public static final String ALLOWED_PATH_CHARS_REG = "^\\w+[ +.+\\w+]*$";
    public static final Pattern ALLOWED_PATH_CHARS_PATTERN = Pattern.compile("^\\w+[ +.+\\w+]*$");

    public static String generateId() {
        return UUID.randomUUID().toString();
    }

    public static BufferedReader getReaderForFile(File file) {
        try {
            FileInputStream is = FileUtils.openInputStream((File)file);
            return new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
            return null;
        }
    }

    public static String getSafeFilename(String filename) {
        String result = filename;
        if (result != null) {
            result = result.replaceAll("[^ a-zA-Z0-9]+", "_").replaceAll("^-+", "");
        }
        return result;
    }

    public static boolean isValidForFilePath(String data) {
        return ALLOWED_PATH_CHARS_PATTERN.matcher(data).find();
    }

    public static String getIdentifierForFilePath(String name, UUID uuid) {
        return CommonUtils.isValidForFilePath(name) ? name : uuid.toString();
    }
}

