/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.tdm.repo;

import java.util.List;

import javax.annotation.Nonnull;

import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumnIdentity;
import org.qubership.atp.tdm.utils.TestDataQueries;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface ColumnRepository extends JpaRepository<TestDataTableColumn, TestDataTableColumnIdentity> {

    List<TestDataTableColumn> findAllByIdentityTableNameAndIdentityColumnNameIn(@Nonnull String tableName,
                                                                                @Nonnull List<String> names);

    List<TestDataTableColumn> findAllByIdentityTableName(@Nonnull String tableName);

    @Query(value = TestDataQueries.DISTINCT_COLUMN_BY_TABLE_NAME, nativeQuery = true)
    List<TestDataTableColumn> findDistinctByIdentityTableName();

    void deleteByIdentity_TableName(@Nonnull String tableName);
}
