/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.ei;

import java.util.UUID;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.qubership.atp.ei.node.dto.ExportScope;
import org.qubership.atp.tdm.ei.AbstractExportImportTest;
import org.qubership.atp.tdm.ei.ServiceScopeEntities;
import org.qubership.atp.tdm.ei.TdmExportExecutor;
import org.qubership.atp.tdm.model.ei.ExportTable;
import org.springframework.beans.factory.annotation.Autowired;

public class TdmExportExecutorTest
extends AbstractExportImportTest {
    private String tableNamePositiveCase;
    ExportScope exportScope = new ExportScope();
    @Autowired
    TdmExportExecutor exportExecutor;

    @BeforeEach
    public void setUp() throws Exception {
        this.tableNamePositiveCase = this.tableName + UUID.randomUUID();
        this.tableNamePositiveCase = this.tableNamePositiveCase.replaceAll("-", "_");
        this.exportScope.getEntities().put(ServiceScopeEntities.ENTITY_ATP_TDM_TABLES.getValue(), this.createSetUuid());
        this.runExport(this.exportExecutor, this.exportScope, this.tableNamePositiveCase);
    }

    @AfterEach
    public void tearDown() {
        this.deleteTestDataTableIfExists(this.tableNamePositiveCase);
        this.catalogRepository.deleteByTableName(this.tableNamePositiveCase);
    }

    @Test
    public void exportToFolder_exportProjectToSpecifiedFolder_dataExportedSuccessfullyProjectIdIsValid() {
        Assertions.assertEquals((Object)exportImportProjectId, (Object)this.exportImportObject.getProjectId());
    }

    @Test
    public void exportToFolder_exportProjectToSpecifiedFolder_dataExportedSuccessfullySystemIdIsValid() {
        Assertions.assertEquals((Object)systemId, (Object)((ExportTable)this.exportImportObject.getTables().stream().findFirst().get()).getSystemId());
    }

    @Test
    public void exportToFolder_exportProjectToSpecifiedFolder_dataExportedSuccessfullyEnvironmentIdIsValid() {
        Assertions.assertEquals((Object)environmentId, (Object)((ExportTable)this.exportImportObject.getTables().stream().findFirst().get()).getEnvironmentId());
    }

    @Test
    public void exportToFolder_exportProjectToSpecifiedFolder_dataExportedSuccessfullyTableNameIsValid() {
        Assertions.assertEquals((Object)this.tableNamePositiveCase, (Object)((ExportTable)this.exportImportObject.getTables().stream().findFirst().get()).getTableName());
    }

    @Test
    public void exportToFolder_exportProjectToSpecifiedFolder_dataExportedSuccessfullyTableTitleIsValid() {
        Assertions.assertEquals((Object)this.tableTitle, (Object)((ExportTable)this.exportImportObject.getTables().stream().findFirst().get()).getTableTitle());
    }

    @Test
    public void exportToFolder_exportProjectToSpecifiedFolder_dataExportedSuccessfullyDataExists() {
        Assertions.assertFalse((boolean)((ExportTable)this.exportImportObject.getTables().stream().findFirst().get()).getData().isEmpty());
    }

    @Test
    public void exportToFolder_exportProjectToSpecifiedFolder_dataExportedAndFlagsSetCorrectly() {
        Assertions.assertFalse((boolean)((ExportTable)this.exportImportObject.getTables().stream().findFirst().get()).getFlagsTable().isUnoccupiedValidation());
    }
}

