/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.websocket.bulkaction.cleanup;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.model.CommonResults;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.bulkaction.BulkActionConfig;
import org.qubership.atp.tdm.model.bulkaction.BulkActionResult;
import org.qubership.atp.tdm.model.cleanup.CleanupResults;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkCleanupMailSender;
import org.qubership.atp.tdm.repo.CleanupConfigRepository;
import org.qubership.atp.tdm.websocket.bulkaction.cleanup.BulkDataCleanupHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class BulkActionHandlerTest
extends AbstractTestDataTest {
    private final ObjectMapper objectMapper = new ObjectMapper();
    TdmMdcHelper helper = new TdmMdcHelper();
    @Autowired
    ExecutorService executorService;
    @Autowired
    CleanupConfigRepository cleanupConfigRepository;
    @Autowired
    BulkCleanupMailSender bulkCleanupMailSender;
    @MockBean
    WebSocketSession session;
    BulkDataCleanupHandler bulkDataCleanupHandler;

    @BeforeEach
    public void setUp() throws Exception {
        this.bulkDataCleanupHandler = new BulkDataCleanupHandler(this.executorService, this.catalogRepository, this.environmentsService, this.cleanupService, this.cleanupConfigRepository, this.bulkCleanupMailSender, this.currentTime, this.lockManager, this.helper);
        Mockito.when((Object)this.session.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.session.getUri()).thenReturn((Object)new URI("localhost:8080/"));
        Mockito.when((Object)this.environmentsService.getLazyProjectById((UUID)ArgumentMatchers.any())).thenReturn((Object)lazyProject);
        Mockito.when((Object)this.environmentsService.getEnvNameById((UUID)ArgumentMatchers.any())).thenReturn((Object)"Test Environment");
        Mockito.when((Object)this.environmentsService.getLazyEnvironmentsShort((UUID)ArgumentMatchers.any())).thenReturn(Collections.singletonList(lazyEnvironment));
        Mockito.when((Object)this.environmentsService.getConnectionsSystemById((UUID)ArgumentMatchers.any())).thenReturn((Object)connections);
    }

    @Test
    public void handleTextMessageTest_doNotFoundTableForCleanup_sendMessageNothingFound() throws Exception {
        UUID projectId = UUID.randomUUID();
        String tableName = "tdm_run_handle_cleanup_sql_config_error_project_id";
        final String tableTitle = "TDM Run Handler Cleanup SQL Config Error Project Id";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(UUID.randomUUID());
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        String strConfig = this.objectMapper.writeValueAsString((Object)bulkActionConfig);
        long processId = 111L;
        Mockito.when((Object)this.currentTime.getCurrentTimeMillis()).thenReturn((Object)111L);
        this.bulkDataCleanupHandler.handleTextMessage(this.session, new TextMessage((CharSequence)strConfig));
        Thread.sleep(5000L);
        this.deleteTestDataTableIfExists("tdm_run_handle_cleanup_sql_config_error_project_id");
        ((WebSocketSession)Mockito.verify((Object)this.session)).sendMessage((WebSocketMessage)new TextMessage((CharSequence)"{\"id\":111, \"status\": \"STARTED\"}"));
        ((WebSocketSession)Mockito.verify((Object)this.session)).sendMessage((WebSocketMessage)new TextMessage((CharSequence)"{\"id\":111, \"status\": \"NOTHING_FOUND\"}"));
        ((WebSocketSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).close(CloseStatus.NORMAL);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void handleTextMessageTest_cleanupTable_sendMessageBulkActionResult() throws Exception {
        final UUID projectId = UUID.randomUUID();
        String tableName = "tdm_run_handler_cleanup_sql_config";
        final String tableTitle = "TDM Run Handler Cleanup SQL Config";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(projectId);
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        TestDataTableCatalog tableCatalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        this.mockEnvironmentService(Collections.singletonList(environmentId), systemId, systemId);
        this.createSqlCleanupConfig(tableCatalog, true);
        BulkActionResult expectedBulkActionResult = new BulkActionResult(tableTitle, tableName, "Test Environment", (CommonResults)new CleanupResults(tableName, 6, 6));
        String strExpectedBulkActionResult = this.objectMapper.writeValueAsString((Object)expectedBulkActionResult);
        String strBulkActionConfig = this.objectMapper.writeValueAsString((Object)bulkActionConfig);
        long processId = 111L;
        Mockito.when((Object)this.currentTime.getCurrentTimeMillis()).thenReturn((Object)111L);
        this.bulkDataCleanupHandler.handleTextMessage(this.session, new TextMessage((CharSequence)strBulkActionConfig));
        Thread.sleep(5000L);
        ((WebSocketSession)Mockito.verify((Object)this.session)).sendMessage((WebSocketMessage)new TextMessage((CharSequence)"{\"id\":111, \"status\": \"STARTED\"}"));
        ((WebSocketSession)Mockito.verify((Object)this.session)).sendMessage((WebSocketMessage)ArgumentMatchers.eq((Object)new TextMessage((CharSequence)strExpectedBulkActionResult)));
        ((WebSocketSession)Mockito.verify((Object)this.session)).sendMessage((WebSocketMessage)new TextMessage((CharSequence)"{\"id\":111, \"status\": \"FINISHED\"}"));
        ((WebSocketSession)Mockito.verify((Object)this.session)).close(CloseStatus.NORMAL);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }
}

