/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.tdm.controllers.api.dto.statistics.AvailableDataByColumnStatsDto;
import org.qubership.atp.tdm.controllers.api.dto.statistics.AvailableDataStatisticsConfigDto;
import org.qubership.atp.tdm.controllers.api.dto.statistics.ConsumedStatisticsDto;
import org.qubership.atp.tdm.controllers.api.dto.statistics.DateStatisticsDto;
import org.qubership.atp.tdm.controllers.api.dto.statistics.GeneralStatisticsItemDto;
import org.qubership.atp.tdm.controllers.api.dto.statistics.OutdatedStatisticsDto;
import org.qubership.atp.tdm.controllers.api.dto.statistics.TestAvailableDataMonitoringDto;
import org.qubership.atp.tdm.controllers.api.dto.statistics.TestDataTableMonitoringDto;
import org.qubership.atp.tdm.controllers.api.dto.statistics.TestDataTableUsersMonitoringDto;
import org.qubership.atp.tdm.controllers.api.dto.statistics.UsersOccupyStatisticRequestDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="StatisticsController", description="Statistics Controller")
public interface StatisticsControllerApi {
    @Operation(operationId="alterOccupiedDateColumn", summary="Old update.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/fix/occupied/date/column"}, produces={"application/json"})
    public ResponseEntity<List<String>> alterOccupiedDateColumn();

    @Operation(operationId="deleteAvailableDataMonitoringConfig", summary="Delete available data monitoring configuration.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/tdm/statistics/schedule/available"})
    public ResponseEntity<Void> deleteAvailableDataMonitoringConfig(@NotNull @Parameter(name="systemId", description="systemId", required=true) @Valid @RequestParam(value="systemId", required=true) UUID var1, @NotNull @Parameter(name="environmentId", description="systemId", required=true) @Valid @RequestParam(value="environmentId", required=true) UUID var2);

    @Operation(operationId="deleteScheduledRun", summary="Delete schedule for statistics monitoring.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/tdm/statistics/delete/schedule"}, consumes={"application/json"})
    public ResponseEntity<Void> deleteScheduledRun(@Parameter(name="TestDataTableMonitoringDto", description="") @Valid @RequestBody(required=false) TestDataTableMonitoringDto var1);

    @Operation(operationId="deleteUsersScheduledRun", summary="Delete schedule for statistics users monitoring.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/tdm/statistics/delete/schedule/users"}, consumes={"application/json"})
    public ResponseEntity<Void> deleteUsersScheduledRun(@Parameter(name="TestDataTableUsersMonitoringDto", description="") @Valid @RequestBody(required=false) TestDataTableUsersMonitoringDto var1);

    @Operation(operationId="getAvailableData", summary="Get available data by column", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AvailableDataByColumnStatsDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/data/occupied/available"}, produces={"application/json"})
    public ResponseEntity<AvailableDataByColumnStatsDto> getAvailableData(@NotNull @Parameter(name="systemId", description="systemId", required=true) @Valid @RequestParam(value="systemId", required=true) UUID var1);

    @Operation(operationId="getAvailableDataMonitoringConfig", summary="Get available data monitoring configuration.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestAvailableDataMonitoringDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/schedule/available"}, produces={"application/json"})
    public ResponseEntity<TestAvailableDataMonitoringDto> getAvailableDataMonitoringConfig(@NotNull @Parameter(name="systemId", description="systemId", required=true) @Valid @RequestParam(value="systemId", required=true) UUID var1, @NotNull @Parameter(name="environmentId", description="systemId", required=true) @Valid @RequestParam(value="environmentId", required=true) UUID var2);

    @Operation(operationId="getAvailableDataStatsConfig", summary="Get available data by column configuration.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AvailableDataStatisticsConfigDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/available/column/configuration"}, produces={"application/json"})
    public ResponseEntity<AvailableDataStatisticsConfigDto> getAvailableDataStatsConfig(@NotNull @Parameter(name="systemId", description="systemId", required=true) @Valid @RequestParam(value="systemId", required=true) UUID var1);

    @Operation(operationId="getMonitoringSchedule", summary="Get statistics monitoring schedule.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestDataTableMonitoringDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/schedule"}, produces={"application/json"})
    public ResponseEntity<TestDataTableMonitoringDto> getMonitoringSchedule(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1);

    @Operation(operationId="getNextScheduledRun", summary="Get next run's date / time details.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/next/run"}, produces={"application/json"})
    public ResponseEntity<Map<String, String>> getNextScheduledRun(@NotNull @Parameter(name="cronExpression", description="cronExpression", required=true) @Valid @RequestParam(value="cronExpression", required=true) String var1);

    @Operation(operationId="getStatisticsByUsers", summary="Get statistics by users.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GeneralStatisticsItemDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/statistics/data/occupied/users"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<GeneralStatisticsItemDto>> getStatisticsByUsers(@Parameter(name="UsersOccupyStatisticRequestDto", description="") @Valid @RequestBody(required=false) UsersOccupyStatisticRequestDto var1);

    @Operation(operationId="getTestDataAvailability", summary="Get test data availability.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GeneralStatisticsItemDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/data/available"}, produces={"application/json"})
    public ResponseEntity<List<GeneralStatisticsItemDto>> getTestDataAvailability(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @Parameter(name="systemId", description="systemId") @Valid @RequestParam(value="systemId", required=false) UUID var2);

    @Operation(operationId="getTestDataConsumption", summary="Get test data consumption.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConsumedStatisticsDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/data/occupied"}, produces={"application/json"})
    public ResponseEntity<ConsumedStatisticsDto> getTestDataConsumption(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="dateFrom", description="dateFrom", required=true) @Valid @RequestParam(value="dateFrom", required=true) String var2, @NotNull @Parameter(name="dateTo", description="dateTo", required=true) @Valid @RequestParam(value="dateTo", required=true) String var3, @Parameter(name="systemId", description="systemId") @Valid @RequestParam(value="systemId", required=false) UUID var4);

    @Operation(operationId="getTestDataConsumptionWhitOutdated", summary="Get test data consumption with outdated.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=OutdatedStatisticsDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/data/outdated"}, produces={"application/json"})
    public ResponseEntity<OutdatedStatisticsDto> getTestDataConsumptionWhitOutdated(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="dateFrom", description="dateFrom", required=true) @Valid @RequestParam(value="dateFrom", required=true) String var2, @NotNull @Parameter(name="dateTo", description="dateTo", required=true) @Valid @RequestParam(value="dateTo", required=true) String var3, @NotNull @Parameter(name="expirationDate", description="expirationDate", required=true) @Valid @RequestParam(value="expirationDate", required=true) String var4, @Parameter(name="systemId", description="systemId") @Valid @RequestParam(value="systemId", required=false) UUID var5);

    @Operation(operationId="getTestDataCreatedWhen", summary="Get test data by created when date.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DateStatisticsDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/data/created/when"}, produces={"application/json"})
    public ResponseEntity<DateStatisticsDto> getTestDataCreatedWhen(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="dateFrom", description="dateFrom", required=true) @Valid @RequestParam(value="dateFrom", required=true) String var2, @NotNull @Parameter(name="dateTo", description="dateTo", required=true) @Valid @RequestParam(value="dateTo", required=true) String var3, @Parameter(name="systemId", description="systemId") @Valid @RequestParam(value="systemId", required=false) UUID var4);

    @Operation(operationId="getThreshold", summary="Get threshold for statistics.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Integer.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/threshold"}, produces={"application/json"})
    public ResponseEntity<Integer> getThreshold();

    @Operation(operationId="getUsersMonitoringSchedule", summary="Get statistics users monitoring schedule.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestDataTableUsersMonitoringDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/statistics/schedule/users"}, produces={"application/json"})
    public ResponseEntity<TestDataTableUsersMonitoringDto> getUsersMonitoringSchedule(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1);

    @Operation(operationId="saveAvailableDataMonitoringConfig", summary="Save available data monitoring configuration.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/statistics/schedule/available"}, consumes={"application/json"})
    public ResponseEntity<Void> saveAvailableDataMonitoringConfig(@Parameter(name="TestAvailableDataMonitoringDto", description="") @Valid @RequestBody(required=false) TestAvailableDataMonitoringDto var1);

    @Operation(operationId="saveAvailableDataStatsConfig", summary="Get available data by column configuration.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/statistics/available/column/configuration"}, consumes={"application/json"})
    public ResponseEntity<Void> saveAvailableDataStatsConfig(@Parameter(name="AvailableDataStatisticsConfigDto", description="") @Valid @RequestBody(required=false) AvailableDataStatisticsConfigDto var1);

    @Operation(operationId="setupScheduledRun", summary="Setup next run in schedule for statistics monitoring.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/statistics/schedule"}, consumes={"application/json"})
    public ResponseEntity<Void> setupScheduledRun(@Parameter(name="TestDataTableMonitoringDto", description="") @Valid @RequestBody(required=false) TestDataTableMonitoringDto var1);

    @Operation(operationId="setupUsersScheduledRun", summary="Setup next run in schedule for statistics users monitoring.", tags={"statistics-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/statistics/schedule/users"}, consumes={"application/json"})
    public ResponseEntity<Void> setupUsersScheduledRun(@Parameter(name="TestDataTableUsersMonitoringDto", description="") @Valid @RequestBody(required=false) TestDataTableUsersMonitoringDto var1);
}

