/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.ei;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.atp.ei.node.ImportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.TestDataTableImportInfo;
import org.qubership.atp.tdm.model.cleanup.TestDataCleanupConfig;
import org.qubership.atp.tdm.model.ei.ExportImportObject;
import org.qubership.atp.tdm.model.ei.ExportTable;
import org.qubership.atp.tdm.model.refresh.TestDataRefreshConfig;
import org.qubership.atp.tdm.model.statistics.TestDataTableMonitoring;
import org.qubership.atp.tdm.model.table.TestDataFlagsTable;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumnIdentity;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.CleanupConfigRepository;
import org.qubership.atp.tdm.repo.ColumnRepository;
import org.qubership.atp.tdm.repo.ImportInfoRepository;
import org.qubership.atp.tdm.repo.RefreshConfigRepository;
import org.qubership.atp.tdm.repo.TestDataColumnFlagsRepository;
import org.qubership.atp.tdm.repo.TestDataMonitoringRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.repo.impl.SystemColumns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TdmImportExecutor
implements ImportExecutor {
    private static final Logger log = LoggerFactory.getLogger(TdmImportExecutor.class);
    private final EnvironmentsService environmentsService;
    private final TestDataTableRepository testDataTableRepository;
    private final CatalogRepository catalogRepository;
    private final CleanupConfigRepository cleanupConfigRepository;
    private final ColumnRepository columnRepository;
    private final ImportInfoRepository importInfoRepository;
    private final RefreshConfigRepository refreshConfigRepository;
    private final TestDataMonitoringRepository testDataMonitoringRepository;
    private final TestDataColumnFlagsRepository testDataColumnFlagsRepository;
    private final ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private List<ExportImportObject> exportImportObjectList;

    public void importData(ExportImportData importData, Path path) throws Exception {
        log.info("start importData(importData: {}, workDir: {})", (Object)importData, (Object)path);
        this.exportImportObjectList.forEach(this::importData);
        this.exportImportObjectList.clear();
        log.info("end importData(importData: {}, workDir: {})", (Object)importData, (Object)path);
    }

    private void importData(@Nonnull ExportImportObject exportImportObject) {
        log.info("Import for project id:[{}] started...", (Object)exportImportObject.getProjectId());
        UUID projectId = exportImportObject.getProjectId();
        TestDataTableMonitoring testDataMonitoring = exportImportObject.getTestDataMonitoring();
        List<ExportTable> tables = exportImportObject.getTables();
        if (Objects.nonNull(testDataMonitoring)) {
            this.testDataMonitoringRepository.save(testDataMonitoring);
        }
        for (ExportTable table : tables) {
            TestDataCleanupConfig cleanupConfig = table.getCleanupConfig();
            TestDataRefreshConfig refreshConfig = table.getRefreshConfig();
            TestDataTableImportInfo importInfo = table.getImportInfo();
            List<TestDataTableColumn> columns = table.getColumns();
            TestDataTableCatalog catalog = this.createTestDataCatalog(new TestDataTableCatalog(), table, projectId, cleanupConfig, refreshConfig, importInfo);
            this.catalogRepository.save(catalog);
            if (Objects.nonNull(cleanupConfig)) {
                this.cleanupConfigRepository.save(cleanupConfig);
            }
            if (Objects.nonNull(columns)) {
                this.columnRepository.saveAll(columns);
            }
            if (Objects.nonNull(importInfo)) {
                this.importInfoRepository.save(importInfo);
            }
            if (Objects.nonNull(refreshConfig)) {
                this.refreshConfigRepository.save(refreshConfig);
            }
            TestDataFlagsTable flags = table.getFlagsTable();
            this.testDataColumnFlagsRepository.save(flags);
            this.saveData(projectId, table, table.getTableName());
        }
        log.info("Import finished.");
    }

    private void createListExportImportObjects(Path path) {
        if (!this.exportImportObjectList.isEmpty()) {
            this.exportImportObjectList.clear();
        }
        Map listObjects = this.objectLoaderFromDiskService.getListOfObjects(path, ExportImportObject.class);
        listObjects.forEach((id, objectPath) -> this.exportImportObjectList.add((ExportImportObject)this.objectLoaderFromDiskService.loadFileAsObject(objectPath, ExportImportObject.class)));
    }

    private void saveData(UUID projectId, ExportTable table, String tableName) {
        List<Map<String, Object>> data = table.getData();
        if (Objects.nonNull(data)) {
            Optional dataFirstRow = data.stream().findFirst();
            if (dataFirstRow.isPresent()) {
                try {
                    this.testDataTableRepository.dropTable(tableName);
                }
                catch (Exception e) {
                    log.warn("Table:[{}] doesn't exist.", (Object)tableName);
                }
                ArrayList<String> columnNames = new ArrayList<String>(((Map)dataFirstRow.get()).keySet());
                TestDataTable testDataTable = this.createTestDataTable(new TestDataTable(), table, tableName, this.generateTestDataTableColumnList(columnNames));
                this.testDataTableRepository.saveTestData(tableName, false, testDataTable);
            }
        } else {
            log.warn("Data was not found in export process. Project id:[{}]", (Object)projectId);
        }
    }

    private List<TestDataTableColumn> generateTestDataTableColumnList(List<String> columnNames) {
        List<String> systemColumns = SystemColumns.getColumnNames();
        return columnNames.stream().filter(c -> !systemColumns.contains(c)).map(c -> new TestDataTableColumn(new TestDataTableColumnIdentity("", (String)c))).collect(Collectors.toList());
    }

    private TestDataTable createTestDataTable(TestDataTable testDataTable, ExportTable table, String tableName, List<TestDataTableColumn> columns) {
        testDataTable.setName(tableName);
        testDataTable.setColumns(columns);
        testDataTable.setData(table.getData());
        return testDataTable;
    }

    private TestDataTableCatalog createTestDataCatalog(TestDataTableCatalog catalog, ExportTable table, UUID projectId, TestDataCleanupConfig cleanupConfig, TestDataRefreshConfig refreshConfig, TestDataTableImportInfo importInfo) {
        catalog.setTableName(table.getTableName());
        catalog.setProjectId(projectId);
        catalog.setEnvironmentId(table.getEnvironmentId());
        catalog.setSystemId(table.getSystemId());
        catalog.setTableTitle(table.getTableTitle());
        if (Objects.nonNull(cleanupConfig)) {
            catalog.setCleanupConfigId(cleanupConfig.getId());
        }
        if (Objects.nonNull(refreshConfig)) {
            catalog.setRefreshConfigId(refreshConfig.getId());
        }
        if (Objects.nonNull(importInfo)) {
            catalog.setImportQuery(importInfo.getTableQuery());
            catalog.setQueryTimeout(importInfo.getQueryTimeout());
        }
        return catalog;
    }

    private List<String> validateData(@Nonnull ExportImportObject exportImportObject, List<String> validations, ExportImportData exportImportData) {
        UUID projectId = exportImportObject.getProjectId();
        log.debug("validateData: {}", (Object)exportImportObject);
        if (exportImportData.isCreateNewProject() || exportImportData.isImportFirstTime()) {
            log.debug("Validation data was skipped, because new project will be created (project id = {})", (Object)projectId);
            return null;
        }
        boolean isProjectExistsInEnvs = this.environmentsService.getLazyProjects().stream().anyMatch(p -> p.getId().equals(projectId));
        if (!isProjectExistsInEnvs) {
            validations.add("Project with id:[" + projectId + "] wasn't found in env service.");
            return validations;
        }
        List<ExportTable> tables = exportImportObject.getTables();
        List lazyEnvironments = this.environmentsService.getLazyEnvironmentsShort(projectId).stream().map(LazyEnvironment::getId).collect(Collectors.toList());
        tables.forEach(table -> {
            UUID envId = table.getEnvironmentId();
            UUID sysId = table.getSystemId();
            if (!lazyEnvironments.contains(envId)) {
                validations.add("Environment with id:[" + envId + "] wasn't found in env service.");
            } else {
                boolean isSystemExists = this.environmentsService.getLazySystems(envId).stream().anyMatch(s -> s.getId().equals(sysId));
                if (!isSystemExists) {
                    validations.add("System with id:[" + sysId + "] wasn't found in env service.");
                }
            }
        });
        return validations;
    }

    public ValidationResult validateData(ExportImportData exportImportData, Path path) {
        ArrayList messages = new ArrayList();
        this.createListExportImportObjects(path);
        this.exportImportObjectList.forEach(exportImportObject -> this.validateData((ExportImportObject)exportImportObject, messages, exportImportData));
        return new ValidationResult(new ArrayList(messages));
    }

    public ValidationResult preValidateData(ExportImportData exportImportData, Path path) {
        return null;
    }

    public TdmImportExecutor(EnvironmentsService environmentsService, TestDataTableRepository testDataTableRepository, CatalogRepository catalogRepository, CleanupConfigRepository cleanupConfigRepository, ColumnRepository columnRepository, ImportInfoRepository importInfoRepository, RefreshConfigRepository refreshConfigRepository, TestDataMonitoringRepository testDataMonitoringRepository, TestDataColumnFlagsRepository testDataColumnFlagsRepository, ObjectLoaderFromDiskService objectLoaderFromDiskService, List<ExportImportObject> exportImportObjectList) {
        this.environmentsService = environmentsService;
        this.testDataTableRepository = testDataTableRepository;
        this.catalogRepository = catalogRepository;
        this.cleanupConfigRepository = cleanupConfigRepository;
        this.columnRepository = columnRepository;
        this.importInfoRepository = importInfoRepository;
        this.refreshConfigRepository = refreshConfigRepository;
        this.testDataMonitoringRepository = testDataMonitoringRepository;
        this.testDataColumnFlagsRepository = testDataColumnFlagsRepository;
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
        this.exportImportObjectList = exportImportObjectList;
    }
}

