/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.mailsender;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.integration.configuration.model.MailRequest;
import org.qubership.atp.integration.configuration.service.MailSenderService;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.model.statistics.TestDataTableUsersMonitoring;
import org.qubership.atp.tdm.model.statistics.report.UsersStatisticsReportObject;
import org.qubership.atp.tdm.service.StatisticsService;
import org.qubership.atp.tdm.service.impl.MetricService;
import org.qubership.atp.tdm.utils.DataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;

@Component
public class UsersStatisticsMailSender {
    private static final Logger log = LoggerFactory.getLogger(UsersStatisticsMailSender.class);
    @Value(value="${mail.sender.enable:true}")
    private boolean mailSenderEnable;
    private final String mailSenderFrom;
    private final Configuration configuration;
    private final StatisticsService statisticsService;
    private final MailSenderService mailSender;
    private final MetricService metricService;
    private final EnvironmentsService environmentsService;
    private final String mailSenderSubject;
    private final String mailSenderTemplate;
    private final String mailSenderPath;
    private static final String EMPTY_HTML_CONTENT = "Statistic by Users.\nPlease, find CSV file with statistic in attachment";

    @Autowired
    private UsersStatisticsMailSender(@Value(value="${mail.sender.from}") String mailSenderFrom, @Nonnull Configuration configuration, @Nonnull StatisticsService statisticsService, @Nonnull MailSenderService mailSenderService, @Nonnull MetricService metricService, @Nonnull EnvironmentsService environmentsService, @Value(value="${mail.sender.users.statistics.subject}") String mailSenderSubject, @Value(value="${mail.sender.users.statistics.template}") String mailSenderTemplate, @Value(value="${mail.sender.users.statistics.path}") String mailSenderPath) {
        this.mailSenderFrom = mailSenderFrom;
        this.configuration = configuration;
        this.statisticsService = statisticsService;
        this.mailSender = mailSenderService;
        this.metricService = metricService;
        this.environmentsService = environmentsService;
        this.mailSenderSubject = mailSenderSubject;
        this.mailSenderTemplate = mailSenderTemplate;
        this.mailSenderPath = mailSenderPath;
    }

    public void send(String projectId) throws Exception {
        block17: {
            if (this.mailSenderEnable) {
                UUID projId = UUID.fromString(projectId);
                this.metricService.executeStatisticsUserJob(projectId);
                TestDataTableUsersMonitoring monitoring = this.statisticsService.getUsersMonitoringSchedule(projId);
                MailRequest mailRequest = new MailRequest();
                mailRequest.setFrom(this.mailSenderFrom);
                mailRequest.setTo(monitoring.getRecipients());
                HashMap<String, UUID> metadata = new HashMap<String, UUID>();
                metadata.put("projectId", projId);
                mailRequest.setMetadata(metadata);
                try {
                    UsersStatisticsReportObject usersStatisticsReportObject = this.statisticsService.getUsersStatisticsReport(monitoring);
                    String content = EMPTY_HTML_CONTENT;
                    if (monitoring.isHtmlReport()) {
                        content = this.buildMessageContent(this.configuration, usersStatisticsReportObject);
                    }
                    mailRequest.setSubject(String.format(this.mailSenderSubject, usersStatisticsReportObject.getProjectName()));
                    mailRequest.setContent(content);
                    if (monitoring.isCsvReport()) {
                        File attachment = this.statisticsService.getCsvReportByUsers(monitoring.getProjectId(), monitoring.getDaysCount());
                        ArrayList<MockMultipartFile> multipartFiles = new ArrayList<MockMultipartFile>();
                        try (ByteArrayInputStream stream = new ByteArrayInputStream(Files.readAllBytes(attachment.toPath()));){
                            MockMultipartFile multipartFileToSend = new MockMultipartFile("application", attachment.getName(), MediaType.APPLICATION_OCTET_STREAM.toString(), (InputStream)stream);
                            multipartFiles.add(multipartFileToSend);
                            this.mailSender.send(mailRequest, multipartFiles);
                            break block17;
                        }
                        catch (IOException exc) {
                            log.error("Failed to attach files to message for {}", (Object)monitoring.getRecipients(), (Object)exc);
                            throw exc;
                        }
                        finally {
                            DataUtils.deleteFile(attachment.toPath());
                        }
                    }
                    this.mailSender.send(mailRequest);
                }
                catch (Exception e) {
                    String messageError = "Error user statistics send mail. Message: " + e.getMessage();
                    String projectName = projectId;
                    try {
                        projectName = this.environmentsService.getLazyProjectById(UUID.fromString(projectId)).getName();
                    }
                    catch (Exception ex) {
                        log.error("Project by Id not found.", (Throwable)ex);
                    }
                    mailRequest.setSubject(String.format(this.mailSenderSubject, "Project: " + projectName));
                    mailRequest.setContent(messageError);
                    this.mailSender.send(mailRequest);
                    throw e;
                }
            }
        }
    }

    private String buildMessageContent(Configuration freemarkerConfig, final UsersStatisticsReportObject messageContent) {
        try {
            freemarkerConfig.setDirectoryForTemplateLoading(new File(this.mailSenderPath));
            Template template = freemarkerConfig.getTemplate(this.mailSenderTemplate);
            StringWriter writer = new StringWriter();
            template.process((Object)new HashMap<String, Object>(){
                {
                    this.put("elements", messageContent.getElements());
                }
            }, (Writer)writer);
            ((Writer)writer).flush();
            return ((Object)writer).toString();
        }
        catch (TemplateException | IOException bmc) {
            String errorMsg = "Error observed while building message content for Test Data users monitoring.";
            log.error(errorMsg, bmc);
            return errorMsg;
        }
    }
}

