/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave;

import brave.CurrentSpanCustomizer;
import brave.Tracing;
import brave.TracingCustomizer;
import brave.handler.SpanHandler;
import brave.propagation.CurrentTraceContext;
import brave.propagation.CurrentTraceContextCustomizer;
import brave.propagation.Propagation;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.sampler.Sampler;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.SleuthAnnotationConfiguration;
import org.springframework.cloud.sleuth.autoconfig.SleuthBaggageProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthSpanFilterProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthTracerProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceConfiguration;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveBaggageConfiguration;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveBridgeConfiguration;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveSamplerConfiguration;
import org.springframework.cloud.sleuth.autoconfig.brave.ConditionalOnBraveEnabled;
import org.springframework.cloud.sleuth.autoconfig.brave.SleuthProperties;
import org.springframework.cloud.sleuth.autoconfig.brave.instrument.web.BraveHttpConfiguration;
import org.springframework.cloud.sleuth.brave.LocalServiceName;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.cloud.sleuth.internal.SleuthContextListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBraveEnabled
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@ConditionalOnMissingBean(value={Tracer.class})
@ConditionalOnClass(value={brave.Tracer.class, SleuthProperties.class})
@EnableConfigurationProperties(value={SleuthProperties.class, SleuthSpanFilterProperties.class, SleuthBaggageProperties.class, SleuthTracerProperties.class, SleuthBaggageProperties.class})
@Import(value={BraveBridgeConfiguration.class, BraveBaggageConfiguration.class, BraveSamplerConfiguration.class, BraveHttpConfiguration.class, TraceConfiguration.class, SleuthAnnotationConfiguration.class})
public class BraveAutoConfiguration {
    public static final String TRACING_BEAN_NAME = "tracing";
    public static final String TRACER_BEAN_NAME = "tracer";
    private static final String DEFAULT_SERVICE_NAME = "default";

    @Bean(name={"tracing"})
    @ConditionalOnMissingBean
    Tracing tracing(@LocalServiceName String serviceName, Propagation.Factory factory, CurrentTraceContext currentTraceContext, Sampler sampler, SleuthProperties sleuthProperties, @Nullable List<SpanHandler> spanHandlers, @Nullable List<TracingCustomizer> tracingCustomizers) {
        Tracing.Builder builder = Tracing.newBuilder().sampler(sampler).localServiceName(!StringUtils.hasText((String)serviceName) ? DEFAULT_SERVICE_NAME : serviceName).propagationFactory(factory).currentTraceContext(currentTraceContext).traceId128Bit(sleuthProperties.isTraceId128()).supportsJoin(sleuthProperties.isSupportsJoin());
        if (spanHandlers != null) {
            for (SpanHandler spanHandlerFactory : spanHandlers) {
                builder.addSpanHandler(spanHandlerFactory);
            }
        }
        if (tracingCustomizers != null) {
            for (TracingCustomizer customizer : tracingCustomizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }

    @Bean(name={"tracer"})
    @ConditionalOnMissingBean
    brave.Tracer tracer(Tracing tracing) {
        return tracing.tracer();
    }

    @Bean
    @ConditionalOnMissingBean
    SpanNamer sleuthSpanNamer() {
        return new DefaultSpanNamer();
    }

    @Bean
    CurrentTraceContext sleuthCurrentTraceContext(CurrentTraceContext.Builder builder, @Nullable List<CurrentTraceContext.ScopeDecorator> scopeDecorators, @Nullable List<CurrentTraceContextCustomizer> currentTraceContextCustomizers) {
        if (scopeDecorators == null) {
            scopeDecorators = Collections.emptyList();
        }
        if (currentTraceContextCustomizers == null) {
            currentTraceContextCustomizers = Collections.emptyList();
        }
        for (CurrentTraceContext.ScopeDecorator scopeDecorator : scopeDecorators) {
            builder.addScopeDecorator(scopeDecorator);
        }
        for (CurrentTraceContextCustomizer currentTraceContextCustomizer : currentTraceContextCustomizers) {
            currentTraceContextCustomizer.customize(builder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    CurrentTraceContext.Builder sleuthCurrentTraceContextBuilder() {
        return ThreadLocalCurrentTraceContext.newBuilder();
    }

    @Bean
    @ConditionalOnMissingBean
    CurrentSpanCustomizer spanCustomizer(Tracing tracing) {
        return CurrentSpanCustomizer.create((Tracing)tracing);
    }

    @Bean
    SleuthContextListener sleuthContextListener() {
        return new SleuthContextListener();
    }
}

