/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.batch;

import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.batch.TraceJobBuilderFactoryBeanPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.batch.TraceStepBuilderFactoryBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JobBuilderFactory.class})
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnProperty(value={"spring.sleuth.batch.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class TraceBatchAutoConfiguration {
    @Bean
    static TraceJobBuilderFactoryBeanPostProcessor traceJobBuilderFactoryBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceJobBuilderFactoryBeanPostProcessor(beanFactory);
    }

    @Bean
    static TraceStepBuilderFactoryBeanPostProcessor traceStepBuilderFactoryBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceStepBuilderFactoryBeanPostProcessor(beanFactory);
    }
}

