/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.atp.ei.ntt.flag.Flag;
import org.qubership.atp.ei.ntt.flag.Option;
import org.qubership.atp.ei.ntt.model.TreeNode;
import org.qubership.atp.ei.ntt.model.impl.AbstractGenericItem;

public abstract class AbstractTreeNode
extends AbstractGenericItem
implements TreeNode {
    private static final Option<?>[] NO_OPTIONS = new Option[0];
    protected TreeNode parent;
    protected List<? extends TreeNode> children = new ArrayList<TreeNode>();
    private Map<String, Flag> flags = new HashMap<String, Flag>();

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    @Override
    public boolean isAncestorFor(TreeNode node) {
        for (TreeNode item = this.getParent(); item != null; item = item.getParent()) {
            if (this != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends TreeNode> List<T> getChildren() {
        return this.children;
    }

    @Override
    public <T extends TreeNode> void setChildren(List<T> children) {
        this.children = children;
    }

    @Override
    public void setFlag(String flag) {
        this.setFlag(flag, true);
    }

    @Override
    public void setFlag(String flag, boolean enabled) {
        if (this.hasFlag(flag)) {
            this.flags.get(flag).setEnabled(enabled);
        } else if (enabled) {
            this.flags.put(flag, new Flag(flag));
        }
    }

    @Override
    public boolean getFlag(String flag) {
        return this.flags.containsKey(flag) && this.flags.get(flag).isEnabled();
    }

    @Override
    public String[] getFlags() {
        ArrayList<String> list = new ArrayList<String>(this.flags.size());
        for (String flag : this.flags.keySet()) {
            if (!this.getFlag(flag)) continue;
            list.add(flag);
        }
        return list.toArray(new String[list.size()]);
    }

    private boolean hasFlag(String flag) {
        return this.flags.containsKey(flag);
    }

    @Override
    public <T> void setFlagOption(String flag, String option, T optionValue) {
        if (this.hasFlag(flag)) {
            this.flags.get(flag).setOptionValue(option, optionValue);
        }
    }

    @Override
    public <T> T getFlagOption(String flag, String option) {
        if (this.hasFlag(flag)) {
            return this.flags.get(flag).getOptionValue(option);
        }
        return null;
    }

    @Override
    public String getFlagOptionString(String flag, String option) {
        return this.getFlagOption(flag, option).toString();
    }

    @Override
    public Option<?>[] getFlagOptions(String flag) {
        if (this.hasFlag(flag)) {
            return this.flags.get(flag).getOptions();
        }
        return NO_OPTIONS;
    }
}

