/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings.model.dal.jdom;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.qubership.atp.ei.ntt.settings.model.dal.AssociableFiledStorer;
import org.qubership.atp.ei.ntt.settings.model.dal.support.DaoFactory;
import org.qubership.atp.ei.ntt.settings.store.file.jdom.JDomOptionProcessor;
import org.qubership.atp.ei.ntt.settings.store.option.OptionProcessor;

public class JDomStorer
implements AssociableFiledStorer {
    private static Logger log = Logger.getLogger(JDomStorer.class);
    private OptionProcessor<Element> processor = new JDomOptionProcessor();
    private Document document;
    private String filePath;
    private final DaoFactory.XmlResource resource;
    private XMLOutputter outputter = null;
    private SAXBuilder builder = null;

    public JDomStorer(DaoFactory.XmlResource resource) {
        this.resource = resource;
    }

    @Override
    public void initAssociations(DaoFactory.ElementDal obj) {
        this.processor.load(obj, this.getDocument().getRootElement());
    }

    @Override
    public void setAssociations(DaoFactory.ElementDal obj) {
        this.processor.save(obj, this.getDocument().getRootElement());
    }

    @Override
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeAs(String filePath) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            this.getOutputter().output(this.getDocument(), (OutputStream)out);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error((Object)"Error writing file", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing stream", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean read() {
        try {
            this.document = this.getBuilder().build(new File(this.filePath));
            return true;
        }
        catch (IOException | JDOMException e) {
            log.error((Object)"Error reading file", e);
            return false;
        }
    }

    @Override
    public boolean write() {
        return this.writeAs(this.filePath);
    }

    private XMLOutputter getOutputter() {
        if (this.outputter == null) {
            this.outputter = new XMLOutputter(Format.getPrettyFormat().setIndent("    "));
        }
        return this.outputter;
    }

    private SAXBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new SAXBuilder();
        }
        return this.builder;
    }

    private Document getDocument() {
        if (this.document == null) {
            this.document = new Document(new Element(this.resource.getRootElementName()));
        }
        return this.document;
    }
}

