/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicForecastRule;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;

public class ContextMustBeSet
extends AbstractLiquibaseBasicForecastRule {
    public ContextMustBeSet() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet) {
        if (changeSet.getContexts().getContexts().isEmpty()) {
            return this.setResultUnsuccessful("Liquibase recommends that contexts be assigned to each changeset to provide better deployment control and to enhance traceability of efforts across changesets. Review the changeset indicated and consider adding a context to it.", null);
        }
        return this.setResultSuccessful(true, null);
    }

    @Override
    public String getDescription() {
        return "This check enforces the Liquibase recommendation that contexts be assigned to each changeset to provide better deployment control and to enhance traceability of efforts across changesets.";
    }

    @Override
    public String getShortName() {
        return "ChangesetContextCheck";
    }

    @Override
    public int getPriority() {
        return 173;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public String getName() {
        return "Changesets Must Have a Context Assigned";
    }
}

