/*
 * Decompiled with CFR 0.152.
 */
package org.antechrestos.restclienttest.mockclient;

import java.io.IOException;
import java.net.URI;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antechrestos.restclienttest.context.Context;
import org.antechrestos.restclienttest.mockclient.MockClientHttpRequest;
import org.antechrestos.restclienttest.utils.URIHelper;
import org.junit.Assert;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;

public class MockClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private Map<HttpMethod, Map<URI, Context>> contexts = new EnumMap<HttpMethod, Map<URI, Context>>(HttpMethod.class);

    public void register(Context context) {
        Map<URI, Context> contextForMethod = this.contexts.get(context.getMethod());
        if (contextForMethod == null) {
            contextForMethod = new HashMap<URI, Context>();
            this.contexts.put(context.getMethod(), contextForMethod);
        }
        contextForMethod.put(context.getUrl(), context);
    }

    public ClientHttpRequest createRequest(URI url, HttpMethod method) throws IOException {
        URI urlWithoutQueriedParameters = URIHelper.removeQueryParameters(url);
        Map<String, List<String>> queriedParameters = URIHelper.getQueryParameters(url);
        String noContextForRequest = "No registered context for  " + method + " on " + urlWithoutQueriedParameters;
        Map<URI, Context> contextForMethod = this.contexts.get(method);
        Assert.assertNotNull((String)noContextForRequest, contextForMethod);
        Context context = contextForMethod.get(urlWithoutQueriedParameters);
        Assert.assertNotNull((String)noContextForRequest, (Object)context);
        return new MockClientHttpRequest(context, queriedParameters);
    }
}

