/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.wmf;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import net.arnx.wmf2svg.gdi.Gdi;
import net.arnx.wmf2svg.gdi.GdiBrush;
import net.arnx.wmf2svg.gdi.GdiFont;
import net.arnx.wmf2svg.gdi.GdiObject;
import net.arnx.wmf2svg.gdi.GdiPalette;
import net.arnx.wmf2svg.gdi.GdiRegion;
import net.arnx.wmf2svg.gdi.Point;
import net.arnx.wmf2svg.gdi.wmf.WmfConstants;
import net.arnx.wmf2svg.gdi.wmf.WmfParseException;
import net.arnx.wmf2svg.io.DataInput;

public class WmfParser
implements WmfConstants {
    private static Logger log = Logger.getLogger(WmfParser.class.getName());

    /*
     * WARNING - void declaration
     */
    public void parse(InputStream is, Gdi gdi) throws IOException, WmfParseException {
        block100: {
            DataInput in = null;
            boolean isEmpty = true;
            try {
                in = new DataInput(new BufferedInputStream(is), ByteOrder.LITTLE_ENDIAN);
                int mtType = 0;
                int mtHeaderSize = 0;
                long key = in.readUint32();
                isEmpty = false;
                if (key == -1698247209L) {
                    int hmf = in.readInt16();
                    int vsx = in.readInt16();
                    int vsy = in.readInt16();
                    int vex = in.readInt16();
                    int vey = in.readInt16();
                    int dpi = in.readUint16();
                    long reserved = in.readUint32();
                    int checksum = in.readUint16();
                    gdi.placeableHeader(vsx, vsy, vex, vey, dpi);
                    mtType = in.readUint16();
                    mtHeaderSize = in.readUint16();
                } else {
                    mtType = (int)(key & 0xFFFFL);
                    mtHeaderSize = (int)((key & 0xFFFFFFFFFFFF0000L) >> 16);
                }
                int mtVersion = in.readUint16();
                long mtSize = in.readUint32();
                int mtNoObjects = in.readUint16();
                long mtMaxRecord = in.readUint32();
                int mtNoParameters = in.readUint16();
                if (mtType != 1 || mtHeaderSize != 9) {
                    throw new WmfParseException("invalid file format.");
                }
                gdi.header();
                GdiObject[] objs = new GdiObject[mtNoObjects];
                block73: while (true) {
                    int i;
                    int size = (int)in.readUint32() - 3;
                    int id = in.readUint16();
                    if (id == 0) break;
                    in.setCount(0);
                    block1 : switch (id) {
                        case 1078: {
                            int i2;
                            int[] nArray = new int[in.readUint16()];
                            int startIndex = in.readUint16();
                            int objID = in.readUint16();
                            for (i2 = 0; i2 < nArray.length; ++i2) {
                                nArray[i2] = in.readInt32();
                            }
                            gdi.animatePalette((GdiPalette)objs[objID], startIndex, nArray);
                            break;
                        }
                        case 2071: {
                            int n = in.readInt16();
                            int exa = in.readInt16();
                            int sya = in.readInt16();
                            int sxa = in.readInt16();
                            int eyr = in.readInt16();
                            int exr = in.readInt16();
                            int syr = in.readInt16();
                            int sxr = in.readInt16();
                            gdi.arc(sxr, syr, exr, eyr, sxa, sya, exa, n);
                            break;
                        }
                        case 2338: {
                            long l = in.readUint32();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            int height = in.readInt16();
                            int width = in.readInt16();
                            int dy = in.readInt16();
                            int dx = in.readInt16();
                            byte[] image = in.readBytes(size * 2 - in.getCount());
                            gdi.bitBlt(image, dx, dy, width, height, sx, sy, l);
                            break;
                        }
                        case 2096: {
                            int n = in.readInt16();
                            int exa = in.readInt16();
                            int sya = in.readInt16();
                            int sxa = in.readInt16();
                            int eyr = in.readInt16();
                            int exr = in.readInt16();
                            int syr = in.readInt16();
                            int sxr = in.readInt16();
                            gdi.chord(sxr, syr, exr, eyr, sxa, sya, exa, n);
                            break;
                        }
                        case 764: {
                            int n = in.readUint16();
                            int color = in.readInt32();
                            int hatch = in.readUint16();
                            for (int i2 = 0; i2 < objs.length; ++i2) {
                                if (objs[i2] != null) continue;
                                objs[i2] = gdi.createBrushIndirect(n, color, hatch);
                                break block1;
                            }
                            break;
                        }
                        case 763: {
                            int n = in.readInt16();
                            int width = in.readInt16();
                            int escapement = in.readInt16();
                            int orientation = in.readInt16();
                            int weight = in.readInt16();
                            boolean italic = in.readByte() == 1;
                            boolean underline = in.readByte() == 1;
                            boolean strikeout = in.readByte() == 1;
                            int charset = in.readByte();
                            int outPrecision = in.readByte();
                            int clipPrecision = in.readByte();
                            int quality = in.readByte();
                            int pitchAndFamily = in.readByte();
                            byte[] faceName = in.readBytes(size * 2 - in.getCount());
                            GdiFont obj = gdi.createFontIndirect(n, width, escapement, orientation, weight, italic, underline, strikeout, charset, outPrecision, clipPrecision, quality, pitchAndFamily, faceName);
                            for (int i3 = 0; i3 < objs.length; ++i3) {
                                if (objs[i3] != null) continue;
                                objs[i3] = obj;
                                break block1;
                            }
                            break;
                        }
                        case 247: {
                            int i3;
                            int n = in.readUint16();
                            int[] entries = new int[in.readUint16()];
                            for (int i4 = 0; i4 < entries.length; ++i4) {
                                entries[i4] = in.readInt32();
                            }
                            for (i3 = 0; i3 < objs.length; ++i3) {
                                if (objs[i3] != null) continue;
                                objs[i3] = gdi.createPalette(n, entries);
                                break block1;
                            }
                            break;
                        }
                        case 505: {
                            byte[] byArray = in.readBytes(size * 2 - in.getCount());
                            for (i = 0; i < objs.length; ++i) {
                                if (objs[i] != null) continue;
                                objs[i] = gdi.createPatternBrush(byArray);
                                break block1;
                            }
                            break;
                        }
                        case 762: {
                            int i2;
                            int n = in.readUint16();
                            int width = in.readInt16();
                            in.readInt16();
                            int color = in.readInt32();
                            for (i2 = 0; i2 < objs.length; ++i2) {
                                if (objs[i2] != null) continue;
                                objs[i2] = gdi.createPenIndirect(n, width, color);
                                break block1;
                            }
                            break;
                        }
                        case 1791: {
                            int n = in.readInt16();
                            int ex = in.readInt16();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            for (int i5 = 0; i5 < objs.length; ++i5) {
                                if (objs[i5] != null) continue;
                                objs[i5] = gdi.createRectRgn(sx, sy, ex, n);
                                break block1;
                            }
                            break;
                        }
                        case 496: {
                            int n = in.readUint16();
                            gdi.deleteObject(objs[n]);
                            objs[n] = null;
                            break;
                        }
                        case 2368: {
                            boolean bl;
                            boolean bl2 = false;
                            long rop = in.readUint32();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            int height = in.readInt16();
                            if (height == 0) {
                                height = in.readInt16();
                                bl = true;
                            }
                            int width = in.readInt16();
                            int dy = in.readInt16();
                            int dx = in.readInt16();
                            if (bl) {
                                gdi.dibBitBlt(null, dx, dy, width, height, sx, sy, rop);
                                break;
                            }
                            byte[] image = in.readBytes(size * 2 - in.getCount());
                            gdi.dibBitBlt(image, dx, dy, width, height, sx, sy, rop);
                            break;
                        }
                        case 322: {
                            int i3;
                            int n = in.readInt32();
                            byte[] image = in.readBytes(size * 2 - in.getCount());
                            for (i3 = 0; i3 < objs.length; ++i3) {
                                if (objs[i3] != null) continue;
                                objs[i3] = gdi.dibCreatePatternBrush(image, n);
                                break block1;
                            }
                            break;
                        }
                        case 2881: {
                            long l = in.readUint32();
                            int sh = in.readInt16();
                            int sw = in.readInt16();
                            int sx = in.readInt16();
                            int sy = in.readInt16();
                            int dh = in.readInt16();
                            int dw = in.readInt16();
                            int dy = in.readInt16();
                            int dx = in.readInt16();
                            byte[] image = in.readBytes(size * 2 - in.getCount());
                            gdi.dibStretchBlt(image, dx, dy, dw, dh, sx, sy, sw, sh, l);
                            break;
                        }
                        case 1048: {
                            int n = in.readInt16();
                            int ex = in.readInt16();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            gdi.ellipse(sx, sy, ex, n);
                            break;
                        }
                        case 1574: {
                            byte[] byArray = in.readBytes(2 * size);
                            gdi.escape(byArray);
                            break;
                        }
                        case 1045: {
                            int n = in.readInt16();
                            int ex = in.readInt16();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            gdi.excludeClipRect(sx, sy, ex, n);
                            break;
                        }
                        case 1352: {
                            int n = in.readUint16();
                            int color = in.readInt32();
                            int y = in.readInt16();
                            int x = in.readInt16();
                            gdi.extFloodFill(x, y, color, n);
                            break;
                        }
                        case 2610: {
                            void var19_44;
                            int n = size;
                            int y = in.readInt16();
                            int x = in.readInt16();
                            int count = in.readInt16();
                            int options = in.readUint16();
                            var19_43 -= 4;
                            int[] rect = null;
                            if ((options & 6) > 0) {
                                rect = new int[]{in.readInt16(), in.readInt16(), in.readInt16(), in.readInt16()};
                                var19_44 -= 4;
                            }
                            byte[] text = in.readBytes(count);
                            if (count % 2 == 1) {
                                in.readByte();
                            }
                            void var19_45 = var19_44 - (count + 1) / 2;
                            int[] dx = null;
                            if (var19_45 > 0) {
                                dx = new int[var19_45];
                                for (int i6 = 0; i6 < dx.length; ++i6) {
                                    dx[i6] = in.readInt16();
                                }
                            }
                            gdi.extTextOut(x, y, options, rect, text, dx);
                            break;
                        }
                        case 552: {
                            int n = in.readUint16();
                            int rgnID = in.readUint16();
                            gdi.fillRgn((GdiRegion)objs[rgnID], (GdiBrush)objs[n]);
                            break;
                        }
                        case 1049: {
                            int n = in.readInt32();
                            int y = in.readInt16();
                            int x = in.readInt16();
                            gdi.floodFill(x, y, n);
                            break;
                        }
                        case 1065: {
                            int n = in.readInt16();
                            int width = in.readInt16();
                            int brushID = in.readUint16();
                            int rgnID = in.readUint16();
                            gdi.frameRgn((GdiRegion)objs[rgnID], (GdiBrush)objs[brushID], width, n);
                            break;
                        }
                        case 1046: {
                            int n = in.readInt16();
                            int ex = in.readInt16();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            gdi.intersectClipRect(sx, sy, ex, n);
                            break;
                        }
                        case 298: {
                            int n = in.readUint16();
                            gdi.invertRgn((GdiRegion)objs[n]);
                            break;
                        }
                        case 531: {
                            int n = in.readInt16();
                            int ex = in.readInt16();
                            gdi.lineTo(ex, n);
                            break;
                        }
                        case 532: {
                            int n = in.readInt16();
                            int x = in.readInt16();
                            gdi.moveToEx(x, n, null);
                            break;
                        }
                        case 544: {
                            int n = in.readInt16();
                            int x = in.readInt16();
                            gdi.offsetClipRgn(x, n);
                            break;
                        }
                        case 529: {
                            int n = in.readInt16();
                            int x = in.readInt16();
                            gdi.offsetViewportOrgEx(x, n, null);
                            break;
                        }
                        case 527: {
                            int n = in.readInt16();
                            int x = in.readInt16();
                            gdi.offsetWindowOrgEx(x, n, null);
                            break;
                        }
                        case 299: {
                            int n = in.readUint16();
                            gdi.paintRgn((GdiRegion)objs[n]);
                            break;
                        }
                        case 1565: {
                            long l = in.readUint32();
                            int height = in.readInt16();
                            int width = in.readInt16();
                            int y = in.readInt16();
                            int x = in.readInt16();
                            gdi.patBlt(x, y, width, height, l);
                            break;
                        }
                        case 2074: {
                            int n = in.readInt16();
                            int exr = in.readInt16();
                            int syr = in.readInt16();
                            int sxr = in.readInt16();
                            int ey = in.readInt16();
                            int ex = in.readInt16();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            gdi.pie(sx, sy, ex, ey, sxr, syr, exr, n);
                            break;
                        }
                        case 804: {
                            Point[] pointArray = new Point[in.readInt16()];
                            for (i = 0; i < pointArray.length; ++i) {
                                pointArray[i] = new Point(in.readInt16(), in.readInt16());
                            }
                            gdi.polygon(pointArray);
                            break;
                        }
                        case 805: {
                            Point[] pointArray = new Point[in.readInt16()];
                            for (i = 0; i < pointArray.length; ++i) {
                                pointArray[i] = new Point(in.readInt16(), in.readInt16());
                            }
                            gdi.polyline(pointArray);
                            break;
                        }
                        case 1336: {
                            Point[][] pointArray = new Point[in.readInt16()][];
                            for (i = 0; i < pointArray.length; ++i) {
                                pointArray[i] = new Point[in.readInt16()];
                            }
                            for (i = 0; i < pointArray.length; ++i) {
                                for (int j = 0; j < pointArray[i].length; ++j) {
                                    pointArray[i][j] = new Point(in.readInt16(), in.readInt16());
                                }
                            }
                            gdi.polyPolygon(pointArray);
                            break;
                        }
                        case 53: {
                            gdi.realizePalette();
                            break;
                        }
                        case 1051: {
                            int n = in.readInt16();
                            int ex = in.readInt16();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            gdi.rectangle(sx, sy, ex, n);
                            break;
                        }
                        case 313: {
                            int n = in.readUint16();
                            gdi.resizePalette((GdiPalette)objs[n]);
                            break;
                        }
                        case 295: {
                            int n = in.readInt16();
                            gdi.restoreDC(n);
                            break;
                        }
                        case 1564: {
                            int n = in.readInt16();
                            int rw = in.readInt16();
                            int ey = in.readInt16();
                            int ex = in.readInt16();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            gdi.roundRect(sx, sy, ex, ey, rw, n);
                            break;
                        }
                        case 30: {
                            gdi.seveDC();
                            break;
                        }
                        case 1042: {
                            int n = in.readInt16();
                            int y = in.readInt16();
                            int xd = in.readInt16();
                            int x = in.readInt16();
                            gdi.scaleViewportExtEx(x, xd, y, n, null);
                            break;
                        }
                        case 1040: {
                            int n = in.readInt16();
                            int y = in.readInt16();
                            int xd = in.readInt16();
                            int x = in.readInt16();
                            gdi.scaleWindowExtEx(x, xd, y, n, null);
                            break;
                        }
                        case 300: {
                            int n = in.readUint16();
                            GdiRegion rgn = n > 0 ? (GdiRegion)objs[n] : null;
                            gdi.selectClipRgn(rgn);
                            break;
                        }
                        case 301: {
                            int n = in.readUint16();
                            gdi.selectObject(objs[n]);
                            break;
                        }
                        case 564: {
                            boolean bl;
                            boolean bl3 = bl = in.readInt16() != 0;
                            if (size * 2 - in.getCount() <= 0) break;
                            int objID = in.readUint16();
                            gdi.selectPalette((GdiPalette)objs[objID], bl);
                            break;
                        }
                        case 513: {
                            int n = in.readInt32();
                            gdi.setBkColor(n);
                            break;
                        }
                        case 258: {
                            int n = in.readInt16();
                            gdi.setBkMode(n);
                            break;
                        }
                        case 3379: {
                            int n = in.readUint16();
                            int scanlines = in.readUint16();
                            int startscan = in.readUint16();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            int dh = in.readInt16();
                            int dw = in.readInt16();
                            int dy = in.readInt16();
                            int dx = in.readInt16();
                            byte[] image = in.readBytes(size * 2 - in.getCount());
                            gdi.setDIBitsToDevice(dx, dy, dw, dh, sx, sy, startscan, scanlines, image, n);
                            break;
                        }
                        case 329: {
                            long l = in.readUint32();
                            gdi.setLayout(l);
                            break;
                        }
                        case 259: {
                            int n = in.readInt16();
                            gdi.setMapMode(n);
                            break;
                        }
                        case 561: {
                            long l = in.readUint32();
                            gdi.setMapperFlags(l);
                            break;
                        }
                        case 55: {
                            int i2;
                            int[] nArray = new int[in.readUint16()];
                            int startIndex = in.readUint16();
                            int objID = in.readUint16();
                            for (i2 = 0; i2 < nArray.length; ++i2) {
                                nArray[i2] = in.readInt32();
                            }
                            gdi.setPaletteEntries((GdiPalette)objs[objID], startIndex, nArray);
                            break;
                        }
                        case 1055: {
                            int n = in.readInt32();
                            int y = in.readInt16();
                            int x = in.readInt16();
                            gdi.setPixel(x, y, n);
                            break;
                        }
                        case 262: {
                            int n = in.readInt16();
                            gdi.setPolyFillMode(n);
                            break;
                        }
                        case 261: {
                            int n = in.readInt16();
                            gdi.setRelAbs(n);
                            break;
                        }
                        case 260: {
                            int n = in.readInt16();
                            gdi.setROP2(n);
                            break;
                        }
                        case 263: {
                            int n = in.readInt16();
                            gdi.setStretchBltMode(n);
                            break;
                        }
                        case 302: {
                            int n = in.readInt16();
                            gdi.setTextAlign(n);
                            break;
                        }
                        case 264: {
                            int n = in.readInt16();
                            gdi.setTextCharacterExtra(n);
                            break;
                        }
                        case 521: {
                            int n = in.readInt32();
                            gdi.setTextColor(n);
                            break;
                        }
                        case 522: {
                            int n = in.readInt16();
                            int breakExtra = in.readInt16();
                            gdi.setTextJustification(breakExtra, n);
                            break;
                        }
                        case 526: {
                            int n = in.readInt16();
                            int x = in.readInt16();
                            gdi.setViewportExtEx(x, n, null);
                            break;
                        }
                        case 525: {
                            int n = in.readInt16();
                            int x = in.readInt16();
                            gdi.setViewportOrgEx(x, n, null);
                            break;
                        }
                        case 524: {
                            int n = in.readInt16();
                            int width = in.readInt16();
                            gdi.setWindowExtEx(width, n, null);
                            break;
                        }
                        case 523: {
                            int n = in.readInt16();
                            int x = in.readInt16();
                            gdi.setWindowOrgEx(x, n, null);
                            break;
                        }
                        case 2851: {
                            long l = in.readUint32();
                            int sh = in.readInt16();
                            int sw = in.readInt16();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            int dh = in.readInt16();
                            int dw = in.readInt16();
                            int dy = in.readInt16();
                            int dx = in.readInt16();
                            byte[] image = in.readBytes(size * 2 - in.getCount());
                            gdi.stretchBlt(image, dx, dy, dw, dh, sx, sy, sw, sh, l);
                            break;
                        }
                        case 3907: {
                            long l = in.readUint32();
                            int usage = in.readUint16();
                            int sh = in.readInt16();
                            int sw = in.readInt16();
                            int sy = in.readInt16();
                            int sx = in.readInt16();
                            int dh = in.readInt16();
                            int dw = in.readInt16();
                            int dy = in.readInt16();
                            int dx = in.readInt16();
                            byte[] image = in.readBytes(size * 2 - in.getCount());
                            gdi.stretchDIBits(dx, dy, dw, dh, sx, sy, sw, sh, image, usage, l);
                            break;
                        }
                        case 1313: {
                            int n = in.readInt16();
                            byte[] text = in.readBytes(n);
                            if (n % 2 == 1) {
                                in.readByte();
                            }
                            int y = in.readInt16();
                            int x = in.readInt16();
                            gdi.textOut(x, y, text);
                            break;
                        }
                        default: {
                            log.fine("unsuppored id find: " + id + " (size=" + size + ")");
                        }
                    }
                    int n = size * 2 - in.getCount();
                    i = 0;
                    while (true) {
                        if (i >= n) continue block73;
                        in.readByte();
                        ++i;
                    }
                    break;
                }
                in.close();
                gdi.footer();
            }
            catch (EOFException e) {
                if (!isEmpty) break block100;
                throw new WmfParseException("input file size is zero.");
            }
        }
    }
}

