/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.jobs;

import java.nio.file.Paths;
import java.util.List;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.ei.node.services.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"atp.ei.file.cleanup.job.enable"}, matchIfMissing=true)
@EnableScheduling
@ComponentScan(basePackages={"org.qubership.atp.common.lock"})
public class ExportImportFilesCleanerJob {
    private static final Logger log = LoggerFactory.getLogger(ExportImportFilesCleanerJob.class);
    @Value(value="${atp.export.workdir:exportimport/node}")
    private String workDir;
    @Value(value="${atp.ei.file.delete.after.ms:172800000}")
    private Long expirationTimeMillis;
    private final LockManager lockManager;
    private final FileService fileService;

    public ExportImportFilesCleanerJob(LockManager lockManager, FileService fileService) {
        this.lockManager = lockManager;
        this.fileService = fileService;
    }

    @Scheduled(fixedRateString="${atp.ei.file.cleanup.job.fixedRate:86400000}")
    public void scheduledFileRemoving() {
        log.info("Start cleaning old export-import files in folder {}", (Object)this.workDir);
        this.lockManager.executeWithLock("Cleaning up old export-import files", () -> {
            List<String> deletedPaths = this.fileService.removeAllOutdatedFilesAndFolders(Paths.get(this.workDir, new String[0]), this.expirationTimeMillis);
            log.info("Cleaning old export-import files. Removed files and directories: {}", deletedPaths);
        });
        log.info("End cleaning old export-import files in folder {}", (Object)this.workDir);
    }
}

