/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Expression;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberValueObject
extends Expression {
    private Number _value;

    public NumberValueObject(Object value) {
        this((Number)value);
    }

    public NumberValueObject(Number value) {
        this._value = value;
    }

    @Override
    public boolean hasParens() {
        return false;
    }

    public boolean isIntegralInRange(long min, long max) {
        if (this.isFloatingPoint()) {
            return false;
        }
        long value = this._value.longValue();
        return min <= value && value <= max;
    }

    private boolean isFloatingPoint() {
        if (this._value instanceof BigInteger) {
            return false;
        }
        if (this._value instanceof Float || this._value instanceof Double) {
            return true;
        }
        BigDecimal dec = this._value instanceof BigDecimal ? (BigDecimal)this._value : new BigDecimal(this._value.doubleValue());
        return dec.scale() > 0;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        app.append(this._value);
    }
}

