/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.AllTableColumns;
import com.healthmarketscience.sqlbuilder.BaseCTEQuery;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.NumberValueObject;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.Query;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.custom.CustomSyntax;
import com.healthmarketscience.sqlbuilder.custom.HookAnchor;
import com.healthmarketscience.sqlbuilder.custom.HookType;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Join;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class SelectQuery
extends BaseCTEQuery<SelectQuery> {
    private boolean _isDistinct;
    private boolean _forUpdate;
    private SqlObjectList<SqlObject> _columns = SqlObjectList.create();
    private SqlObjectList<SqlObject> _joins = SqlObjectList.create("");
    private List<SqlObject> _joinFromTables = new LinkedList<SqlObject>();
    private ComboCondition _condition = ComboCondition.and();
    private SqlObjectList<SqlObject> _grouping = SqlObjectList.create();
    private SqlObjectList<SqlObject> _ordering = SqlObjectList.create();
    private ComboCondition _having = ComboCondition.and();
    private SqlObjectList<SqlObject> _windows = SqlObjectList.create();
    private SqlObject _offset;
    private SqlObject _fetchCount;

    public SelectQuery() {
        this(false);
    }

    public SelectQuery(boolean isDistinct) {
        this._isDistinct = isDistinct;
    }

    SqlObjectList<SqlObject> getColumns() {
        return this._columns;
    }

    SqlObjectList<SqlObject> getOrdering() {
        return this._ordering;
    }

    boolean hasAllColumns() {
        return SelectQuery.hasAllColumns(this._columns);
    }

    private void addJoinFromTable(SqlObject fromTable) {
        if (this._joins.isEmpty()) {
            this._joins.addObject(fromTable);
        }
        this._joinFromTables.add(fromTable);
    }

    public SelectQuery setIsDistinct(boolean isDistinct) {
        this._isDistinct = isDistinct;
        return this;
    }

    public SelectQuery setForUpdate(boolean forUpdate) {
        this._forUpdate = forUpdate;
        return this;
    }

    public SelectQuery addCustomColumns(Object ... columnStrs) {
        this._columns.addObjects(Converter.COLUMN_VALUE_TO_OBJ, columnStrs);
        return this;
    }

    public SelectQuery addAllColumns() {
        this._columns.addObject(ALL_SYMBOL);
        return this;
    }

    public SelectQuery addAllTableColumns(Table table) {
        this._columns.addObject(new AllTableColumns(table));
        return this;
    }

    public SelectQuery addColumns(Column ... columns) {
        return this.addCustomColumns(columns);
    }

    public SelectQuery addAliasedColumn(Object column, String alias) {
        return this.addCustomColumns(Converter.toColumnSqlObject(column, alias));
    }

    public SelectQuery addCustomFromTable(Object tableStr) {
        SqlObject tableObj = Converter.toCustomTableDefSqlObject(tableStr);
        if (this._joins.isEmpty()) {
            this._joins.addObject(tableObj);
        } else {
            this._joins.addObject(new JoinTo(tableObj));
        }
        return this;
    }

    public SelectQuery addFromTable(Table table) {
        return this.addCustomFromTable(table);
    }

    public SelectQuery addCustomJoin(Object joinStr) {
        SqlObject joinObj = Converter.toCustomTableDefSqlObject(joinStr);
        this._joins.addObject(joinObj);
        return this;
    }

    public SelectQuery addCustomJoin(JoinType joinType, Object fromTableStr, Object toTableStr, Condition joinCond) {
        this.addJoinFromTable(Converter.toCustomTableDefSqlObject(fromTableStr));
        this._joins.addObject(new JoinTo(joinType, Converter.toCustomTableDefSqlObject(toTableStr), joinCond));
        return this;
    }

    public SelectQuery addJoin(JoinType joinType, Table fromTable, Table toTable, Condition joinCond) {
        return this.addCustomJoin(joinType, Converter.toTableDefSqlObject(fromTable), Converter.toTableDefSqlObject(toTable), joinCond);
    }

    public SelectQuery addJoin(JoinType joinType, Table fromTable, Table toTable, List<? extends Column> fromColumns, List<? extends Column> toColumns) {
        this.addJoinFromTable(Converter.toTableDefSqlObject(fromTable));
        this._joins.addObject(new JoinTo(joinType, Converter.toTableDefSqlObject(toTable), fromColumns, toColumns));
        return this;
    }

    public SelectQuery addJoin(JoinType joinType, Table fromTable, Table toTable, Column fromColumn, Column toColumn) {
        return this.addJoin(joinType, fromTable, toTable, Collections.singletonList(fromColumn), Collections.singletonList(toColumn));
    }

    public SelectQuery addJoins(JoinType joinType, Join ... joins) {
        if (joins != null) {
            for (Join join : joins) {
                this.addJoin(joinType, join.getFromTable(), join.getToTable(), join.getFromColumns(), join.getToColumns());
            }
        }
        return this;
    }

    public SelectQuery addCustomOrdering(Object columnStr, OrderObject.Dir dir) {
        return this.addCustomOrderings(new OrderObject(dir, Converter.toCustomColumnSqlObject(columnStr)));
    }

    public SelectQuery addCustomOrderings(Object ... columnStrs) {
        this._ordering.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    public SelectQuery addOrdering(Column column, OrderObject.Dir dir) {
        return this.addCustomOrdering(column, dir);
    }

    public SelectQuery addOrderings(Column ... columns) {
        return this.addCustomOrderings(columns);
    }

    public SelectQuery addIndexedOrdering(Integer columnIdx, OrderObject.Dir dir) {
        return this.addCustomOrdering(columnIdx, dir);
    }

    public SelectQuery addIndexedOrderings(Integer ... columnIdxs) {
        return this.addCustomOrderings(columnIdxs);
    }

    public SelectQuery addCustomGroupings(Object ... columnStrs) {
        this._grouping.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    public SelectQuery addGroupings(Column ... columns) {
        return this.addCustomGroupings(columns);
    }

    public ComboCondition getWhereClause() {
        return this._condition;
    }

    public SelectQuery addCondition(Condition newCondition) {
        this._condition.addCondition(newCondition);
        return this;
    }

    public ComboCondition getHavingClause() {
        return this._having;
    }

    public SelectQuery addHaving(Condition newCondition) {
        this._having.addCondition(newCondition);
        return this;
    }

    public SelectQuery addWindowDefinition(String name, Object window) {
        this._windows.addObject(new NamedWindowDefinition(name, Converter.toCustomSqlObject(window)));
        return this;
    }

    public SelectQuery setOffset(Object offset) {
        this._offset = Converter.toValueSqlObject(offset);
        return this;
    }

    public SelectQuery setFetchNext(Object fetchCount) {
        this._fetchCount = Converter.toValueSqlObject(fetchCount);
        return this;
    }

    public SelectQuery addCustomization(Hook hook, HookType type, Object obj) {
        super.addCustomization(hook, type, obj);
        return this;
    }

    public SelectQuery addCustomization(CustomSyntax obj) {
        if (obj != null) {
            obj.apply(this);
        }
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._joins.collectSchemaObjects(vContext);
        this._columns.collectSchemaObjects(vContext);
        this._condition.collectSchemaObjects(vContext);
        this._grouping.collectSchemaObjects(vContext);
        this._ordering.collectSchemaObjects(vContext);
        this._having.collectSchemaObjects(vContext);
        this._windows.collectSchemaObjects(vContext);
        if (this._offset != null) {
            this._offset.collectSchemaObjects(vContext);
        }
        if (this._fetchCount != null) {
            this._fetchCount.collectSchemaObjects(vContext);
        }
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        boolean checkTables;
        boolean bl = checkTables = !this._joins.isEmpty();
        if (checkTables) {
            this.validateTables(vContext);
        }
        if (checkTables && !this._joinFromTables.isEmpty()) {
            HashSet<Table> joinTables = new HashSet<Table>();
            HashSet<Table> fromTable = new HashSet<Table>();
            HashSet<Column> joinColumns = new HashSet<Column>();
            Iterator<SqlObject> fromIter = this._joinFromTables.iterator();
            Iterator<SqlObject> toIter = this._joins.iterator();
            toIter.next().collectSchemaObjects(new ValidationContext(fromTable, joinColumns));
            while (fromIter.hasNext() && toIter.hasNext()) {
                joinTables.addAll(fromTable);
                fromTable.clear();
                fromIter.next().collectSchemaObjects(new ValidationContext(fromTable, joinColumns));
                if (!joinTables.containsAll(fromTable)) {
                    throw new ValidationException("Table " + fromTable + " used in join is not given among the previous tables: " + joinTables);
                }
                toIter.next().collectSchemaObjects(new ValidationContext(joinTables, joinColumns));
            }
            if (fromIter.hasNext() || toIter.hasNext()) {
                throw new ValidationException("Mismatched tables in joins");
            }
        }
        SelectQuery.validateOrdering(this._columns.size(), this._ordering, this.hasAllColumns());
        SelectQuery.validateValue(this._offset, "Offset", 0);
        SelectQuery.validateValue(this._fetchCount, "Fetch", 1);
    }

    protected static void validateOrdering(int numColumns, SqlObjectList<SqlObject> ordering, boolean ignoreColumnCount) throws ValidationException {
        if (ignoreColumnCount) {
            numColumns = Integer.MAX_VALUE;
        }
        for (SqlObject orderObj : ordering) {
            if (orderObj instanceof OrderObject) {
                orderObj = ((OrderObject)orderObj).getObject();
            }
            if (!(orderObj instanceof NumberValueObject) || ((NumberValueObject)orderObj).isIntegralInRange(1L, numColumns)) continue;
            throw new ValidationException("Ordering index '" + orderObj + "' must be integer in range: 1 to " + numColumns);
        }
    }

    private static void validateValue(SqlObject valueObj, String type, int minVal) {
        if (!(valueObj instanceof NumberValueObject)) {
            return;
        }
        if (!((NumberValueObject)valueObj).isIntegralInRange(minVal, Long.MAX_VALUE)) {
            throw new ValidationException(type + " value must be an integer >= " + minVal + ", given: " + valueObj);
        }
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(true);
        this.customAppendTo(app, Hook.HEADER);
        this.customAppendTo(app, Hook.SELECT, "SELECT ");
        this.maybeAppendTo(app, Hook.DISTINCT, "DISTINCT ", this._isDistinct);
        app.append(this._columns);
        SqlObjectList<SqlObject> joins = this._joins;
        if (joins.isEmpty()) {
            joins = this.buildJoins(newContext);
        }
        this.maybeAppendTo(app, Hook.FROM, " FROM ", joins, !joins.isEmpty());
        this.maybeAppendTo(app, Hook.WHERE, " WHERE ", this._condition, !this._condition.isEmpty());
        boolean hasGroupings = !this._grouping.isEmpty();
        this.maybeAppendTo(app, Hook.GROUP_BY, " GROUP BY ", this._grouping, hasGroupings);
        if (hasGroupings) {
            this.maybeAppendTo(app, Hook.HAVING, " HAVING ", this._having, !this._having.isEmpty());
        }
        this.maybeAppendTo(app, Hook.WINDOW, " WINDOW ", this._windows, !this._windows.isEmpty());
        this.maybeAppendTo(app, Hook.ORDER_BY, " ORDER BY ", this._ordering, !this._ordering.isEmpty());
        if (this._offset != null) {
            app.append(" OFFSET ").append(this._offset).append(" ROWS");
        }
        if (this._fetchCount != null) {
            app.append(" FETCH NEXT ").append(this._fetchCount).append(" ROWS ONLY");
        }
        this.maybeAppendTo(app, Hook.FOR_UPDATE, " FOR UPDATE", this._forUpdate);
        this.customAppendTo(app, Hook.TRAILER);
    }

    private SqlObjectList<SqlObject> buildJoins(SqlContext newContext) {
        SqlObjectList<SqlObject> joins = SqlObjectList.create();
        ValidationContext tmpVContext = new ValidationContext(null, new LinkedHashSet<Column>());
        this.collectSchemaObjects(tmpVContext);
        if (tmpVContext.getColumns().isEmpty()) {
            return joins;
        }
        Collection<Table> columnTables = tmpVContext.getColumnTables(new LinkedHashSet<Table>());
        if (newContext.getParent() != null) {
            ValidationContext outerVContext = new ValidationContext(true);
            SqlContext tmpContext = newContext;
            while ((tmpContext = tmpContext.getParent()) != null) {
                Query<?> parentQuery = tmpContext.getQuery();
                if (parentQuery == null) continue;
                parentQuery.collectSchemaObjects(outerVContext);
            }
            columnTables.removeAll(outerVContext.getColumnTables());
        }
        for (Table table : columnTables) {
            joins.addObject(Converter.toTableDefSqlObject(table));
        }
        return joins;
    }

    static boolean hasAllColumns(SqlObjectList<? extends SqlObject> columns) {
        for (SqlObject sqlObject : columns) {
            if (!(sqlObject instanceof AllTableColumns) && sqlObject != ALL_SYMBOL) continue;
            return true;
        }
        return false;
    }

    private static final class NamedWindowDefinition
    extends SqlObject {
        private final String _name;
        private final SqlObject _definition;

        private NamedWindowDefinition(String name, SqlObject definition) {
            this._name = name;
            this._definition = definition;
        }

        @Override
        protected void collectSchemaObjects(ValidationContext vContext) {
            this._definition.collectSchemaObjects(vContext);
        }

        @Override
        public void appendTo(AppendableExt app) throws IOException {
            app.append(this._name).append(" AS ").append(this._definition);
        }
    }

    private static final class JoinTo
    extends SqlObject {
        private SqlObject _toTable;
        private JoinType _joinType;
        private Condition _onCondition;

        private JoinTo(SqlObject toTable) {
            this(null, toTable, null);
        }

        private JoinTo(JoinType joinType, SqlObject toTable, List<? extends Column> fromColumns, List<? extends Column> toColumns) {
            this(joinType, toTable, ComboCondition.and());
            ComboCondition onCondition = (ComboCondition)this._onCondition;
            for (int i = 0; i < fromColumns.size(); ++i) {
                onCondition.addCondition(BinaryCondition.equalTo(fromColumns.get(i), toColumns.get(i)));
            }
        }

        private JoinTo(JoinType joinType, SqlObject toTable, Condition onCondition) {
            this._toTable = toTable;
            this._joinType = joinType;
            this._onCondition = onCondition;
        }

        @Override
        protected void collectSchemaObjects(ValidationContext vContext) {
            this._toTable.collectSchemaObjects(vContext);
            if (this._onCondition != null) {
                this._onCondition.collectSchemaObjects(vContext);
            }
        }

        @Override
        public void appendTo(AppendableExt app) throws IOException {
            if (this._joinType != null) {
                app.append((Object)this._joinType).append(this._toTable).append(" ON ").append(this._onCondition);
            } else {
                app.append(", ").append(this._toTable);
            }
        }
    }

    public static enum Hook implements HookAnchor
    {
        HEADER,
        SELECT,
        DISTINCT,
        FROM,
        WHERE,
        GROUP_BY,
        HAVING,
        WINDOW,
        ORDER_BY,
        FOR_UPDATE,
        TRAILER;

    }

    public static enum JoinType {
        INNER(" INNER JOIN "),
        LEFT_OUTER(" LEFT OUTER JOIN "),
        RIGHT_OUTER(" RIGHT OUTER JOIN "),
        FULL_OUTER(" FULL OUTER JOIN ");

        private final String _joinClause;

        private JoinType(String joinClause) {
            this._joinClause = joinClause;
        }

        public String toString() {
            return this._joinClause;
        }
    }
}

