/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.notification.client;

import java.util.Collections;
import java.util.List;
import org.qubership.atp.integration.configuration.feign.NotificationFeignClient;
import org.qubership.atp.integration.configuration.model.notification.Notification;
import org.qubership.atp.integration.configuration.notification.client.NotificationClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestNotificationClient
implements NotificationClient {
    private static final Logger log = LoggerFactory.getLogger(RestNotificationClient.class);
    private static final String ERROR_MESSAGE = "Sending of notification message to atp-notification is failed";
    private final NotificationFeignClient notificationFeignClient;

    @Override
    public void sendNotification(Notification notification) {
        try {
            log.info("Send notification via REST");
            this.notificationFeignClient.sendNotifications(Collections.singletonList(notification));
        }
        catch (Exception e) {
            log.error(ERROR_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void sendNotifications(List<Notification> notifications) {
        try {
            log.info("Send notifications via REST. Count: {}", (Object)notifications.size());
            this.notificationFeignClient.sendNotifications(notifications);
        }
        catch (Exception e) {
            log.error(ERROR_MESSAGE, (Throwable)e);
        }
    }

    public RestNotificationClient(NotificationFeignClient notificationFeignClient) {
        this.notificationFeignClient = notificationFeignClient;
    }
}

