/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import java.util.Set;
import java.util.TreeSet;
import org.docx4j.convert.out.ConversionFeatures;
import org.docx4j.convert.out.common.preprocess.BookmarkMover;
import org.docx4j.convert.out.common.preprocess.Containerization;
import org.docx4j.convert.out.common.preprocess.CoverPageSectPrMover;
import org.docx4j.convert.out.common.preprocess.FieldsCombiner;
import org.docx4j.convert.out.common.preprocess.FopWorkaroundDisablePageBreakOnFirstParagraph;
import org.docx4j.convert.out.common.preprocess.FopWorkaroundReplacePageBreakInEachList;
import org.docx4j.convert.out.common.preprocess.PageBreak;
import org.docx4j.convert.out.common.preprocess.ParagraphStylesInTableFix;
import org.docx4j.convert.out.common.preprocess.PartialDeepCopy;
import org.docx4j.convert.out.html.ListsToContentControls;
import org.docx4j.events.EventFinished;
import org.docx4j.events.StartEvent;
import org.docx4j.events.WellKnownProcessSteps;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preprocess
extends ConversionFeatures {
    private static Logger log = LoggerFactory.getLogger(Preprocess.class);

    public static OpcPackage process(OpcPackage opcPackage, Set<String> features) throws Docx4JException {
        OpcPackage ret = opcPackage;
        Set<String> relationshipTypes = null;
        Preprocess.checkParams(opcPackage, features);
        relationshipTypes = Preprocess.createRelationshipTypes(features);
        if (features.contains("pp.common.deepcopy") && (ret = PartialDeepCopy.process(opcPackage, relationshipTypes)) instanceof WordprocessingMLPackage) {
            log.debug("Results of PP_COMMON_DEEP_COPY: " + ((WordprocessingMLPackage)ret).getMainDocumentPart().getXML());
        }
        return ret;
    }

    protected static Set<String> createRelationshipTypes(Set<String> features) {
        TreeSet<String> relationshipTypes = new TreeSet<String>();
        if (features.contains("pp.common.movebookmarks") || features.contains("pp.common.containerization") || features.contains("pp.common.combinefields")) {
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header");
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer");
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/endnotes");
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes");
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments");
        }
        if (features.contains("pp.common.movepagebreak")) {
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        }
        return relationshipTypes;
    }

    public static WordprocessingMLPackage process(WordprocessingMLPackage wmlPackage, Set<String> features) throws Docx4JException {
        WordprocessingMLPackage ret = (WordprocessingMLPackage)Preprocess.process((OpcPackage)wmlPackage, features);
        StartEvent startEvent = new StartEvent(ret, WellKnownProcessSteps.CONVERT_PREPROCESS);
        startEvent.publish();
        if (features.contains("pp.common.combinefields")) {
            log.debug("PP_COMMON_COMBINE_FIELDS");
            FieldsCombiner.process(ret);
        }
        if (features.contains("pp.common.movebookmarks")) {
            log.debug("PP_COMMON_MOVE_BOOKMARKS");
            BookmarkMover.process(ret);
        }
        if (features.contains("pp.common.movepagebreak")) {
            log.debug("PP_COMMON_MOVE_PAGEBREAK");
            PageBreak.process(ret);
        }
        if (features.contains("pp.common.coverpagemovesectpr")) {
            log.debug("PP_COMMON_COVERPAGE_MOVE_SECTPR");
            CoverPageSectPrMover.process(ret);
        }
        if (features.contains("pp.common.containerization")) {
            log.debug("PP_COMMON_CONTAINERIZATION");
            Containerization.process(ret);
        }
        if (features.contains("pp.html.collectlists")) {
            log.debug("PP_HTML_COLLECT_LISTS");
            ListsToContentControls.process(ret);
        }
        if (features.contains("pp.apachefop.disablepagebreakfirstparagraph")) {
            log.debug("PP_APACHEFOP_DISABLE_PAGEBREAK_FIRST_PARAGRAPH");
            FopWorkaroundDisablePageBreakOnFirstParagraph.process(ret);
        }
        if (features.contains("pp.apachefop.disablepagebreaklistitem")) {
            log.debug("PP_APACHEFOP_DISABLE_PAGEBREAK_LIST_ITEM");
            FopWorkaroundReplacePageBreakInEachList.process(ret);
        }
        if (features.contains("pp.common.tbl-p-style-fix")) {
            log.debug("PP_COMMON_TABLE_PARAGRAPH_STYLE_FIX");
            ParagraphStylesInTableFix.process(ret);
        }
        log.debug("Results of preprocessing: " + ret.getMainDocumentPart().getXML());
        new EventFinished(startEvent).publish();
        return ret;
    }
}

