/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.entities.Group;
import org.qubership.atp.auth.springbootstarter.entities.Permissions;
import org.qubership.atp.auth.springbootstarter.entities.Role;
import org.springframework.util.CollectionUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Project
implements Serializable {
    private static final long serialVersionUID = -7878008971600457198L;
    private UUID uuid;
    private Set<UUID> leads;
    private Set<UUID> qaTaEngineers;
    private Set<UUID> devOpsEngineers;
    private Set<UUID> atpRunners;
    private Set<UUID> atpSupports;
    private Permissions permissions;

    public Group getUserGroup(UUID userId, Set<String> userRoles) {
        if (!Objects.isNull(this.leads) && this.leads.contains(userId)) {
            return Group.LEAD;
        }
        if (!Objects.isNull(this.qaTaEngineers) && this.qaTaEngineers.contains(userId)) {
            return Group.ENGINEER;
        }
        if (!Objects.isNull(this.devOpsEngineers) && this.devOpsEngineers.contains(userId)) {
            return Group.DEVOPS;
        }
        if (!Objects.isNull(this.atpRunners) && this.atpRunners.contains(userId)) {
            return Group.EXECUTOR;
        }
        if (this.isSupportGroup(userRoles) || this.isSupportGroupByUserId(userId)) {
            return Group.SUPPORT;
        }
        return Group.DEFAULT;
    }

    private boolean isSupportGroupByUserId(UUID userId) {
        return !Objects.isNull(this.atpSupports) && this.atpSupports.contains(userId);
    }

    private boolean isSupportGroup(Set<String> userRoles) {
        return !CollectionUtils.isEmpty(userRoles) && userRoles.stream().anyMatch(role -> Role.ATP_SUPPORT.name().equalsIgnoreCase((String)role));
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Set<UUID> getLeads() {
        return this.leads;
    }

    public Set<UUID> getQaTaEngineers() {
        return this.qaTaEngineers;
    }

    public Set<UUID> getDevOpsEngineers() {
        return this.devOpsEngineers;
    }

    public Set<UUID> getAtpRunners() {
        return this.atpRunners;
    }

    public Set<UUID> getAtpSupports() {
        return this.atpSupports;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setLeads(Set<UUID> leads) {
        this.leads = leads;
    }

    public void setQaTaEngineers(Set<UUID> qaTaEngineers) {
        this.qaTaEngineers = qaTaEngineers;
    }

    public void setDevOpsEngineers(Set<UUID> devOpsEngineers) {
        this.devOpsEngineers = devOpsEngineers;
    }

    public void setAtpRunners(Set<UUID> atpRunners) {
        this.atpRunners = atpRunners;
    }

    public void setAtpSupports(Set<UUID> atpSupports) {
        this.atpSupports = atpSupports;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        Set<UUID> this$leads = this.getLeads();
        Set<UUID> other$leads = other.getLeads();
        if (this$leads == null ? other$leads != null : !((Object)this$leads).equals(other$leads)) {
            return false;
        }
        Set<UUID> this$qaTaEngineers = this.getQaTaEngineers();
        Set<UUID> other$qaTaEngineers = other.getQaTaEngineers();
        if (this$qaTaEngineers == null ? other$qaTaEngineers != null : !((Object)this$qaTaEngineers).equals(other$qaTaEngineers)) {
            return false;
        }
        Set<UUID> this$devOpsEngineers = this.getDevOpsEngineers();
        Set<UUID> other$devOpsEngineers = other.getDevOpsEngineers();
        if (this$devOpsEngineers == null ? other$devOpsEngineers != null : !((Object)this$devOpsEngineers).equals(other$devOpsEngineers)) {
            return false;
        }
        Set<UUID> this$atpRunners = this.getAtpRunners();
        Set<UUID> other$atpRunners = other.getAtpRunners();
        if (this$atpRunners == null ? other$atpRunners != null : !((Object)this$atpRunners).equals(other$atpRunners)) {
            return false;
        }
        Set<UUID> this$atpSupports = this.getAtpSupports();
        Set<UUID> other$atpSupports = other.getAtpSupports();
        if (this$atpSupports == null ? other$atpSupports != null : !((Object)this$atpSupports).equals(other$atpSupports)) {
            return false;
        }
        Permissions this$permissions = this.getPermissions();
        Permissions other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        Set<UUID> $leads = this.getLeads();
        result = result * 59 + ($leads == null ? 43 : ((Object)$leads).hashCode());
        Set<UUID> $qaTaEngineers = this.getQaTaEngineers();
        result = result * 59 + ($qaTaEngineers == null ? 43 : ((Object)$qaTaEngineers).hashCode());
        Set<UUID> $devOpsEngineers = this.getDevOpsEngineers();
        result = result * 59 + ($devOpsEngineers == null ? 43 : ((Object)$devOpsEngineers).hashCode());
        Set<UUID> $atpRunners = this.getAtpRunners();
        result = result * 59 + ($atpRunners == null ? 43 : ((Object)$atpRunners).hashCode());
        Set<UUID> $atpSupports = this.getAtpSupports();
        result = result * 59 + ($atpSupports == null ? 43 : ((Object)$atpSupports).hashCode());
        Permissions $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    public String toString() {
        return "Project(uuid=" + this.getUuid() + ", leads=" + this.getLeads() + ", qaTaEngineers=" + this.getQaTaEngineers() + ", devOpsEngineers=" + this.getDevOpsEngineers() + ", atpRunners=" + this.getAtpRunners() + ", atpSupports=" + this.getAtpSupports() + ", permissions=" + this.getPermissions() + ")";
    }
}

