/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.ssl;

import java.security.KeyStore;
import java.util.Objects;
import javax.net.ssl.TrustManagerFactory;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.springframework.beans.factory.annotation.Autowired;

public class TrustManagerFactoryProvider
implements Provider<TrustManagerFactory> {
    @Autowired
    private Provider<KeyStore> keyStoreProvider;
    private TrustManagerFactory trustManagerFactory;

    @Override
    public TrustManagerFactory get() {
        if (Objects.isNull(this.trustManagerFactory)) {
            this.trustManagerFactory = this.createTrustManagerFactory();
        }
        return this.trustManagerFactory;
    }

    private TrustManagerFactory createTrustManagerFactory() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(this.keyStoreProvider.get());
            return trustManagerFactory;
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create TrustManagerFactory.", e);
        }
    }
}

