/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jwt;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.jwt.HeaderParameters;
import org.springframework.security.jwt.JwtAlgorithms;
import org.springframework.security.jwt.JwtHeader;
import org.springframework.security.jwt.codec.Codecs;
import org.springframework.security.jwt.crypto.sign.Signer;

class JwtHeaderHelper {
    JwtHeaderHelper() {
    }

    static JwtHeader create(String header) {
        byte[] bytes = Codecs.b64UrlDecode(header);
        return new JwtHeader(bytes, JwtHeaderHelper.parseParams(bytes));
    }

    static JwtHeader create(Signer signer, Map<String, String> params) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(params);
        map.put("alg", JwtAlgorithms.sigAlg(signer.algorithm()));
        HeaderParameters p = new HeaderParameters(map);
        return new JwtHeader(JwtHeaderHelper.serializeParams(p), p);
    }

    static HeaderParameters parseParams(byte[] header) {
        Map<String, String> map = JwtHeaderHelper.parseMap(Codecs.utf8Decode(header));
        return new HeaderParameters(map);
    }

    private static Map<String, String> parseMap(String json) {
        if (json != null) {
            if ((json = json.trim()).startsWith("{")) {
                return JwtHeaderHelper.parseMapInternal(json);
            }
            if (json.equals("")) {
                return new LinkedHashMap<String, String>();
            }
        }
        throw new IllegalArgumentException("Invalid JSON (null)");
    }

    private static Map<String, String> parseMapInternal(String json) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        json = JwtHeaderHelper.trimLeadingCharacter(JwtHeaderHelper.trimTrailingCharacter(json, '}'), '{');
        for (String pair : json.split(",")) {
            String[] values = pair.split(":");
            String key = JwtHeaderHelper.strip(values[0], '\"');
            String value = null;
            if (values.length > 0) {
                value = JwtHeaderHelper.strip(values[1], '\"');
            }
            if (map.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate '" + key + "' field");
            }
            map.put(key, value);
        }
        return map;
    }

    private static String strip(String string, char c) {
        return JwtHeaderHelper.trimLeadingCharacter(JwtHeaderHelper.trimTrailingCharacter(string.trim(), c), c);
    }

    private static String trimTrailingCharacter(String string, char c) {
        if (string.length() >= 0 && string.charAt(string.length() - 1) == c) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String trimLeadingCharacter(String string, char c) {
        if (string.length() >= 0 && string.charAt(0) == c) {
            return string.substring(1);
        }
        return string;
    }

    private static byte[] serializeParams(HeaderParameters params) {
        StringBuilder builder = new StringBuilder("{");
        JwtHeaderHelper.appendField(builder, "alg", params.alg);
        if (params.typ != null) {
            JwtHeaderHelper.appendField(builder, "typ", params.typ);
        }
        for (Map.Entry<String, String> entry : params.map.entrySet()) {
            JwtHeaderHelper.appendField(builder, entry.getKey(), entry.getValue());
        }
        builder.append("}");
        return Codecs.utf8Encode(builder.toString());
    }

    private static void appendField(StringBuilder builder, String name, String value) {
        if (builder.length() > 1) {
            builder.append(",");
        }
        builder.append("\"").append(name).append("\":\"").append(value).append("\"");
    }
}

