/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.cassandra;

import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.EventValue;
import org.springframework.cloud.sleuth.docs.TagKey;

enum SleuthCassandraSpan implements DocumentedSpan
{
    CASSANDRA_SPAN{

        public String getName() {
            return "%s";
        }

        public TagKey[] getTagKeys() {
            return Tags.values();
        }

        public EventValue[] getEvents() {
            return Events.values();
        }

        public String prefix() {
            return "cassandra.";
        }
    };


    static enum Events implements EventValue
    {
        NODE_ERROR{

            public String getValue() {
                return "cassandra.node.error";
            }
        }
        ,
        NODE_SUCCESS{

            public String getValue() {
                return "cassandra.node.success";
            }
        };

    }

    static enum Tags implements TagKey
    {
        KEYSPACE_NAME{

            public String getKey() {
                return "cassandra.keyspace";
            }
        }
        ,
        NODE_ERROR_TAG{

            public String getKey() {
                return "cassandra.node[%s].error";
            }
        }
        ,
        CQL_TAG{

            public String getKey() {
                return "cassandra.cql";
            }
        };

    }
}

