/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.servlet;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.sleuth.http.HttpServerRequest;
import org.springframework.lang.Nullable;

public class HttpServletRequestWrapper
implements HttpServerRequest {
    private static final List<String> COMBINABLE_HEADERS = Collections.singletonList("baggage");
    HttpServletRequest delegate;

    public static HttpServerRequest create(HttpServletRequest request) {
        return new HttpServletRequestWrapper(request);
    }

    HttpServletRequestWrapper(HttpServletRequest delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    public Collection<String> headerNames() {
        return Collections.list(this.delegate.getHeaderNames());
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String method() {
        return this.delegate.getMethod();
    }

    public String route() {
        Object maybeRoute = this.delegate.getAttribute("http.route");
        return maybeRoute instanceof String ? (String)maybeRoute : null;
    }

    public String path() {
        return this.delegate.getRequestURI();
    }

    public String url() {
        StringBuffer url = this.delegate.getRequestURL();
        if (this.delegate.getQueryString() != null && !this.delegate.getQueryString().isEmpty()) {
            url.append('?').append(this.delegate.getQueryString());
        }
        return url.toString();
    }

    public String header(String name) {
        if (COMBINABLE_HEADERS.contains(name)) {
            LinkedList<String> headersList = new LinkedList<String>();
            Enumeration headers = this.delegate.getHeaders(name);
            while (headers.hasMoreElements()) {
                headersList.add((String)headers.nextElement());
            }
            return headersList.size() != 0 ? String.join((CharSequence)",", headersList) : null;
        }
        return this.delegate.getHeader(name);
    }

    @Nullable
    Throwable maybeError() {
        Object maybeError = this.delegate.getAttribute("error");
        if (maybeError instanceof Throwable) {
            return (Throwable)maybeError;
        }
        maybeError = this.delegate.getAttribute("javax.servlet.error.exception");
        if (maybeError instanceof Throwable) {
            return (Throwable)maybeError;
        }
        return null;
    }
}

