/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.reactive;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.crypto.RsaKeyConversionServicePostProcessor;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.reactive.result.view.CsrfRequestDataValueProcessor;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.WebFilterChainProxy;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

@Configuration(proxyBeanMethods=false)
class WebFluxSecurityConfiguration {
    public static final int WEB_FILTER_CHAIN_FILTER_ORDER = -100;
    private static final String BEAN_NAME_PREFIX = "org.springframework.security.config.annotation.web.reactive.WebFluxSecurityConfiguration.";
    private static final String SPRING_SECURITY_WEBFILTERCHAINFILTER_BEAN_NAME = "org.springframework.security.config.annotation.web.reactive.WebFluxSecurityConfiguration.WebFilterChainFilter";
    public static final String REACTIVE_CLIENT_REGISTRATION_REPOSITORY_CLASSNAME = "org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository";
    private static final boolean isOAuth2Present = ClassUtils.isPresent((String)"org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository", (ClassLoader)WebFluxSecurityConfiguration.class.getClassLoader());
    private List<SecurityWebFilterChain> securityWebFilterChains;
    @Autowired
    ApplicationContext context;

    WebFluxSecurityConfiguration() {
    }

    @Autowired(required=false)
    void setSecurityWebFilterChains(List<SecurityWebFilterChain> securityWebFilterChains) {
        this.securityWebFilterChains = securityWebFilterChains;
    }

    @Bean(value={"org.springframework.security.config.annotation.web.reactive.WebFluxSecurityConfiguration.WebFilterChainFilter"})
    @Order(value=-100)
    WebFilterChainProxy springSecurityWebFilterChainFilter() {
        return new WebFilterChainProxy(this.getSecurityWebFilterChains());
    }

    @Bean(name={"requestDataValueProcessor"})
    CsrfRequestDataValueProcessor requestDataValueProcessor() {
        return new CsrfRequestDataValueProcessor();
    }

    @Bean
    static BeanFactoryPostProcessor conversionServicePostProcessor() {
        return new RsaKeyConversionServicePostProcessor();
    }

    private List<SecurityWebFilterChain> getSecurityWebFilterChains() {
        List<SecurityWebFilterChain> result = this.securityWebFilterChains;
        if (ObjectUtils.isEmpty(result)) {
            return Arrays.asList(this.springSecurityFilterChain());
        }
        return result;
    }

    private SecurityWebFilterChain springSecurityFilterChain() {
        ServerHttpSecurity http = (ServerHttpSecurity)this.context.getBean(ServerHttpSecurity.class);
        return this.springSecurityFilterChain(http);
    }

    private SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http) {
        http.authorizeExchange().anyExchange().authenticated();
        if (isOAuth2Present && OAuth2ClasspathGuard.shouldConfigure(this.context)) {
            OAuth2ClasspathGuard.configure(this.context, http);
        } else {
            http.httpBasic();
            http.formLogin();
        }
        SecurityWebFilterChain result = http.build();
        return result;
    }

    private static class OAuth2ClasspathGuard {
        private OAuth2ClasspathGuard() {
        }

        static void configure(ApplicationContext context, ServerHttpSecurity http) {
            http.oauth2Login();
            http.oauth2Client();
        }

        static boolean shouldConfigure(ApplicationContext context) {
            ClassLoader loader = context.getClassLoader();
            Class reactiveClientRegistrationRepositoryClass = ClassUtils.resolveClassName((String)WebFluxSecurityConfiguration.REACTIVE_CLIENT_REGISTRATION_REPOSITORY_CLASSNAME, (ClassLoader)loader);
            return context.getBeanNamesForType(reactiveClientRegistrationRepositoryClass).length == 1;
        }
    }
}

