/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.statistics;

import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.qubership.atp.tdm.utils.scheduler.ScheduleConfig;

@Entity
public class TestDataTableMonitoring
implements ScheduleConfig {
    @Id
    @Column(name="project_id")
    private UUID projectId;
    @Column(name="enabled")
    private boolean enabled;
    @Column(name="cron_expression")
    private String cronExpression;
    @Column(name="threshold")
    private int threshold;
    @Column(name="recipients")
    private String recipients;
    @Transient
    @JsonIgnore
    private UUID id;
    @Transient
    @JsonIgnore
    private String schedule;
    @Transient
    @JsonIgnore
    private String scheduled;

    @Override
    public UUID getId() {
        return this.projectId;
    }

    @Override
    public String getSchedule() {
        return this.cronExpression;
    }

    @Override
    public boolean isScheduled() {
        return this.enabled && StringUtils.isNotEmpty((String)this.cronExpression);
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public String getScheduled() {
        return this.scheduled;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public void setScheduled(String scheduled) {
        this.scheduled = scheduled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestDataTableMonitoring)) {
            return false;
        }
        TestDataTableMonitoring other = (TestDataTableMonitoring)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$cronExpression = this.getCronExpression();
        String other$cronExpression = other.getCronExpression();
        if (this$cronExpression == null ? other$cronExpression != null : !this$cronExpression.equals(other$cronExpression)) {
            return false;
        }
        String this$recipients = this.getRecipients();
        String other$recipients = other.getRecipients();
        if (this$recipients == null ? other$recipients != null : !this$recipients.equals(other$recipients)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$schedule = this.getSchedule();
        String other$schedule = other.getSchedule();
        if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) {
            return false;
        }
        String this$scheduled = this.getScheduled();
        String other$scheduled = other.getScheduled();
        return !(this$scheduled == null ? other$scheduled != null : !this$scheduled.equals(other$scheduled));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestDataTableMonitoring;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getThreshold();
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        String $cronExpression = this.getCronExpression();
        result = result * 59 + ($cronExpression == null ? 43 : $cronExpression.hashCode());
        String $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : $recipients.hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        String $scheduled = this.getScheduled();
        result = result * 59 + ($scheduled == null ? 43 : $scheduled.hashCode());
        return result;
    }

    public String toString() {
        return "TestDataTableMonitoring(projectId=" + this.getProjectId() + ", enabled=" + this.isEnabled() + ", cronExpression=" + this.getCronExpression() + ", threshold=" + this.getThreshold() + ", recipients=" + this.getRecipients() + ", id=" + this.getId() + ", schedule=" + this.getSchedule() + ", scheduled=" + this.getScheduled() + ")";
    }
}

