/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvDbConnectionException;
import org.qubership.atp.tdm.env.configurator.model.Connection;
import org.qubership.atp.tdm.env.configurator.model.Server;
import org.qubership.atp.tdm.exceptions.internal.TdmJsonParsingException;
import org.qubership.atp.tdm.model.DateFormatter;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.repo.impl.SystemColumns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataUtils {
    private static final Logger log = LoggerFactory.getLogger(TestDataUtils.class);

    public static List<String> getColumnsNamesFromQuery(@Nonnull String query) {
        log.debug("Get column names from query:[{}]", (Object)query);
        int indexOfFirstSpace = query.indexOf(" ");
        int indexOfFromWord = query.indexOf("from");
        String[] columns = query.substring(indexOfFirstSpace + 1, indexOfFromWord - 1).split(",");
        List<String> columnNames = Arrays.stream(columns).map(c -> {
            c = c.trim();
            return c;
        }).collect(Collectors.toList());
        log.debug("Column names parsed:[{}]", columnNames);
        return columnNames;
    }

    public static String escapeCharacters(@Nonnull String value) {
        if (value.contains("'")) {
            return value.replaceAll("'", "''");
        }
        return value;
    }

    public static String generateInsertTemplate(String tableName, List<String> columns, boolean systemColumnExists) {
        StringBuilder query = new StringBuilder("INSERT INTO " + tableName + " (");
        StringBuilder values = new StringBuilder("VALUES (");
        if (!systemColumnExists) {
            query.append("\"").append(SystemColumns.ROW_ID.getName()).append("\"").append(", ").append("\"").append(SystemColumns.CREATED_WHEN.getName()).append("\"").append(", ");
            values.append("uuid_generate_v4()").append(", ").append("'").append(DateFormatter.DB_DATE_FORMATTER.format(new Timestamp(new Date().getTime()))).append("'").append(", ");
        }
        for (String column : columns) {
            query.append("\"").append(column).append("\"").append(", ");
            values.append("?, ");
        }
        query.setLength(query.length() - 2);
        values.setLength(values.length() - 2);
        query.append(") ").append((CharSequence)values).append(")");
        return query.toString();
    }

    public static String convertToJsonString(Object rowContent) {
        try {
            return new ObjectMapper().writeValueAsString(rowContent);
        }
        catch (JsonProcessingException e) {
            log.error(String.format("Error while parsing inner cell JSON: %s", rowContent), (Throwable)e);
            throw new TdmJsonParsingException(rowContent);
        }
    }

    public static Integer getIndexHeaderColumnByName(TestDataTable testDataTable, String columnName) {
        return Iterables.indexOf(testDataTable.getColumns(), c -> {
            assert (c != null);
            return columnName.equals(c.getIdentity().getColumnName());
        });
    }

    public static Server getServer(List<Connection> connections, String type) {
        Connection connection = connections.stream().filter(sys -> type.equalsIgnoreCase(sys.getName())).findFirst().orElseThrow(() -> new TdmEnvDbConnectionException(type));
        return new Server(connection, type);
    }

    public static Connection getConnection(List<Connection> connections, String type) {
        Connection connection = connections.stream().filter(sys -> type.equalsIgnoreCase(sys.getName())).findFirst().orElseThrow(() -> new TdmEnvDbConnectionException(type));
        return connection;
    }
}

